/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ao.v2025_x;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.util.Map;
import org.slf4j.LoggerFactory;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.Message;
import vivid.lib.messages.VTE19InternalError;
import vivid.trace.ao.TraceConfigurationAO;

public class V20250x_UpgradeTask_0_TraceConfiguration
implements ActiveObjectsUpgradeTask {
    private static final String ACTIVE_OBJECTS_MODEL_VERSION_20250x0000 = "20250x0000";
    private static final String ISSUE_FIELDS_JSON_KEY_2021_1 = "issueFieldsJson";
    private static final String ITEM_CARD_LAYOUT_2025_x = "item-card-layout";
    private static final io.vavr.collection.Map<String, String> TC_CONFIGURATION_KEY_REPLACEMENTS = HashMap.of("issueFieldsJson", "item-card-layout");

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)ACTIVE_OBJECTS_MODEL_VERSION_20250x0000);
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        ActiveObjectz.pagedExecution(activeObjects, TraceConfigurationAO.class, entity -> {
            Either<Message, String> result = V20250x_UpgradeTask_0_TraceConfiguration.upgradeConfiguration(entity);
            if (result.isRight()) {
                entity.setConfiguration(result.get());
                entity.save();
            } else {
                LoggerFactory.getLogger(V20250x_UpgradeTask_0_TraceConfiguration.class).error(result.getLeft().toString());
            }
        }, this.getClass());
    }

    private static Either<Message, String> upgradeConfiguration(TraceConfigurationAO entity) {
        Map<String, Object> oldConfiguration;
        try {
            oldConfiguration = Jackson.readValue(entity.getConfiguration(), new Jackson.TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            return Either.left(VTE19InternalError.builder(Option.none(), "Failed to read JSON configuration from TraceConfigurationAO ID " + entity.getID(), e).addDetail("active-objects-entity", entity.toString()).build());
        }
        java.util.HashMap<String, Object> newConfiguration = new java.util.HashMap<String, Object>(oldConfiguration.size());
        for (Map.Entry<String, Object> entry : oldConfiguration.entrySet()) {
            newConfiguration.put(TC_CONFIGURATION_KEY_REPLACEMENTS.getOrElse(entry.getKey(), entry.getKey()), entry.getValue());
        }
        try {
            return Either.right(Jackson.writeValueAsString(newConfiguration));
        }
        catch (IOException e) {
            return Either.left(VTE19InternalError.builder(Option.none(), "Failed to write upgraded JSON configuration for TraceConfigurationAO ID " + entity.getID(), e).addDetail("active-objects-entity", entity.toString()).build());
        }
    }
}

