/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.Map;
import vivid.trace.accesscontrols.TraceVisibilityAccessControl;
import vivid.trace.data.ContextualTraceConfigurationQuickList;
import vivid.trace.datatypes.ObjectKeyValue;

@Named
public class AddOnConfiguration {
    private final ActiveObjects activeObjects;
    private final ContextualTraceConfigurationQuickList contextualTraceConfigurationQuickList;
    private final TraceVisibilityAccessControl traceVisibilityAccessControl;

    @Inject
    public AddOnConfiguration(@ComponentImport ActiveObjects activeObjects, ContextualTraceConfigurationQuickList contextualTraceConfigurationQuickList, TraceVisibilityAccessControl traceVisibilityAccessControl) {
        this.activeObjects = activeObjects;
        this.contextualTraceConfigurationQuickList = contextualTraceConfigurationQuickList;
        this.traceVisibilityAccessControl = traceVisibilityAccessControl;
    }

    public int getGraphTraversalTimeLimit() {
        return ObjectKeyValue.getAsInt(this.activeObjects, AddOnConfigurationCompositeKey.GRAPH_TRAVERSAL_TIME_LIMIT_COMPOSITE_KEY, 3000);
    }

    public void setGraphTraversalTimeLimit(int value) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, AddOnConfigurationCompositeKey.GRAPH_TRAVERSAL_TIME_LIMIT_COMPOSITE_KEY, Integer.toString(Math.max(value, 1)));
    }

    public void resetGraphTraversalTimeLimit() {
        ObjectKeyValue.delete(this.activeObjects, AddOnConfigurationCompositeKey.GRAPH_TRAVERSAL_TIME_LIMIT_COMPOSITE_KEY);
    }

    public int getIssueCountSoftMaximum() {
        return ObjectKeyValue.getAsInt(this.activeObjects, AddOnConfigurationCompositeKey.ISSUE_COUNT_SOFT_MAXIMUM_COMPOSITE_KEY, 1000);
    }

    public void setIssueCountSoftMaximum(int value) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, AddOnConfigurationCompositeKey.ISSUE_COUNT_SOFT_MAXIMUM_COMPOSITE_KEY, Integer.toString(Math.max(value, 1)));
    }

    public void resetIssueCountSoftMaximum() {
        ObjectKeyValue.delete(this.activeObjects, AddOnConfigurationCompositeKey.ISSUE_COUNT_SOFT_MAXIMUM_COMPOSITE_KEY);
    }

    public String getContextualTraceConfigurationQuickList() {
        return this.contextualTraceConfigurationQuickList.getAddonComputedValue();
    }

    public void setContextualTraceConfigurationQuickList(String value) {
        this.contextualTraceConfigurationQuickList.setAddonValue(value);
    }

    public String getIssueContextTraceDisplayFormat() {
        Option<String> valueOption = ObjectKeyValue.getValue(this.activeObjects, AddOnConfigurationCompositeKey.ISSUE_CONTEXT_TRACE_DISPLAY_FORMAT);
        if (valueOption.isDefined()) {
            return valueOption.get();
        }
        return "issuetabpanel";
    }

    public void setIssueContextTraceDisplayFormat(String value) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, AddOnConfigurationCompositeKey.ISSUE_CONTEXT_TRACE_DISPLAY_FORMAT, value);
    }

    public Object getTraceVisibility() {
        return this.traceVisibilityAccessControl.getForAddOn(TraceVisibilityAccessControl.OptionalFields.NAME);
    }

    public void setTraceVisibility(Collection<Map<String, String>> members) {
        this.traceVisibilityAccessControl.setForAddOn(members);
    }

    public void resetTraceVisibility() {
        this.traceVisibilityAccessControl.deleteForAddOn();
    }

    public Option<String> getVividIssuedLicense() {
        return ObjectKeyValue.getValue(this.activeObjects, AddOnConfigurationCompositeKey.VIVID_ISSUED_LICENSE_COMPOSITE_KEY);
    }

    public void setVividIssuedLicense(String rawLicense) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, AddOnConfigurationCompositeKey.VIVID_ISSUED_LICENSE_COMPOSITE_KEY, rawLicense);
    }

    public void removeVividIssuedLicense() {
        ObjectKeyValue.delete(this.activeObjects, AddOnConfigurationCompositeKey.VIVID_ISSUED_LICENSE_COMPOSITE_KEY);
    }

    private static enum AddOnConfigurationCompositeKey implements ObjectKeyValue.CompositeKey
    {
        GRAPH_TRAVERSAL_TIME_LIMIT_COMPOSITE_KEY("addon", "0", "graph-traversal-time-limit"),
        ISSUE_CONTEXT_TRACE_DISPLAY_FORMAT("addon", "0", "issue-context-trace-display-format"),
        ISSUE_COUNT_SOFT_MAXIMUM_COMPOSITE_KEY("addon", "0", "issue-count-soft-maximum"),
        VIVID_ISSUED_LICENSE_COMPOSITE_KEY("addon", "0", "vivid-issued-license");

        final String objectType;
        final String objectId;
        final String key;

        private AddOnConfigurationCompositeKey(String objectType, String objectId, String key) {
            this.objectType = objectType;
            this.objectId = objectId;
            this.key = key;
        }

        @Override
        public String getObjectType() {
            return this.objectType;
        }

        @Override
        public String getObjectId() {
            return this.objectId;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }
}

