/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Objects;
import vivid.trace.components.VersionComparator;

@Named
public class AddOnInformation {
    private final BuildUtilsInfo buildUtilsInfo;
    private final PluginAccessor pluginAccessor;

    @Inject
    public AddOnInformation(@ComponentImport BuildUtilsInfo buildUtilsInfo, @ComponentImport PluginAccessor pluginAccessor) {
        this.buildUtilsInfo = Objects.requireNonNull(buildUtilsInfo);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
    }

    public String getAddOnVersion() {
        PluginInformation pluginInformation = this.pluginAccessor.getPlugin("vivid.trace").getPluginInformation();
        return pluginInformation.getVersion();
    }

    public boolean isJiraVersion(VersionComparator jiraVersionComparator, int ... versionComponents) {
        int[] actualVersion = this.buildUtilsInfo.getVersionNumbers();
        return jiraVersionComparator.compare(AddOnInformation.lexicographicalComparator(actualVersion, versionComponents));
    }

    private static int lexicographicalComparator(int[] left, int[] right) {
        int minLength = Math.min(left.length, right.length);
        for (int i = 0; i < minLength; ++i) {
            int result = Integer.compare(left[i], right[i]);
            if (result == 0) continue;
            return result;
        }
        return left.length - right.length;
    }
}

