/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.EnumSet;
import java.util.Objects;
import vivid.lib.I18n;
import vivid.lib.atlassian.messages.MessageReportingAdapter;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.trace.customfield.DirectionsCustomFieldManager;
import vivid.trace.jira.lib.Jira;
import vivid.trace.license.AddOnLicensing;

@Named
public class AddOnPreconditions {
    private final AddOnLicensing addOnLicensing;
    private final ApplicationProperties applicationProperties;
    private final DirectionsCustomFieldManager directionsCustomFieldManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final Option<I18n.ResolverAdapter> i18nResolverAdapterOption;
    private final IssueLinkManager issueLinkManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SubTaskManager subTaskManager;

    @Inject
    public AddOnPreconditions(AddOnLicensing addOnLicensing, @ComponentImport ApplicationProperties applicationProperties, DirectionsCustomFieldManager directionsCustomFieldManager, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport IssueLinkManager issueLinkManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport SubTaskManager subTaskManager) {
        this.addOnLicensing = addOnLicensing;
        this.applicationProperties = applicationProperties;
        this.directionsCustomFieldManager = Objects.requireNonNull(directionsCustomFieldManager);
        this.globalPermissionManager = globalPermissionManager;
        Objects.requireNonNull(i18nResolver);
        this.i18nResolverAdapterOption = Option.of((arg_0, arg_1) -> ((I18nResolver)i18nResolver).getText(arg_0, arg_1));
        this.issueLinkManager = issueLinkManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.subTaskManager = Objects.requireNonNull(subTaskManager);
    }

    public MessageSet getViolationsOfTypes(MessageReportingAdapter adapter, MessageType type, MessageType ... more) {
        EnumSet<MessageType[]> messageTypes = EnumSet.of(type, more);
        boolean hasAnyJiraGlobalAdminPermission = Jira.hasAnyJiraGlobalAdminPermission(this.globalPermissionManager, this.jiraAuthenticationContext.getLoggedInUser());
        MessageSet messageSet = new MessageSet();
        if (messageTypes.contains((Object)MessageType.ERROR)) {
            if (this.isAddOnUnlicensed()) {
                adapter.reportAddOnUnlicensed(messageSet, hasAnyJiraGlobalAdminPermission);
            }
            if (this.isDirectionsCustomFieldInvalid()) {
                adapter.reportDirectionsCustomFieldInvalid(messageSet, hasAnyJiraGlobalAdminPermission);
            }
        }
        if (messageTypes.contains((Object)MessageType.WARNING)) {
            if (this.isIssueLinkingDeactivated()) {
                adapter.reportIssueLinkingDeactivated(messageSet, this.applicationProperties);
            }
            if (this.isSubTasksDisabled()) {
                adapter.reportSubTasksDisabled(messageSet, this.applicationProperties);
            }
        }
        return messageSet;
    }

    public boolean hasViolationsOfTypes(MessageType type, MessageType ... more) {
        EnumSet<MessageType[]> messageTypes = EnumSet.of(type, more);
        return messageTypes.contains((Object)MessageType.ERROR) && (this.isAddOnUnlicensed() || this.isDirectionsCustomFieldInvalid()) || messageTypes.contains((Object)MessageType.WARNING) && (this.isIssueLinkingDeactivated() || this.isSubTasksDisabled());
    }

    private boolean isAddOnUnlicensed() {
        return !this.addOnLicensing.isAddOnLicenseValid(this.i18nResolverAdapterOption);
    }

    private boolean isDirectionsCustomFieldInvalid() {
        return !this.directionsCustomFieldManager.isCustomFieldConfigurationValid();
    }

    private boolean isIssueLinkingDeactivated() {
        return !this.issueLinkManager.isLinkingEnabled();
    }

    private boolean isSubTasksDisabled() {
        return !this.subTaskManager.isSubTasksEnabled();
    }
}

