/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.collection.HashMap;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.trace.ao.AccessControlAO;

@Named
public class Favorites {
    private static final String FAVORITE_AO_ASPECT = "favorite";
    private final ActiveObjects activeObjects;

    @Inject
    public Favorites(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void favoriteTraceConfiguration(int traceConfigurationId, ApplicationUser user) {
        String userKey = user.getKey();
        this.activeObjects.executeInTransaction(() -> {
            boolean hasEntities;
            AccessControlAO[] entities = Favorites.find(this.activeObjects, traceConfigurationId, userKey);
            boolean bl = hasEntities = entities != null && entities.length >= 1;
            if (!hasEntities) {
                Map map = HashMap.of("OBJ", "trace-configuration", "OI", Integer.toString(traceConfigurationId), "ASPECT", FAVORITE_AO_ASPECT, "PTYPE", "user", "PID", userKey).toJavaMap();
                this.activeObjects.create(AccessControlAO.class, map);
            }
            return null;
        });
    }

    public boolean isTraceConfigurationFavorited(int traceConfigurationId, ApplicationUser user) {
        String userKey = user.getKey();
        AccessControlAO[] entities = (AccessControlAO[])this.activeObjects.executeInTransaction(() -> Favorites.find(this.activeObjects, traceConfigurationId, userKey));
        return entities != null && entities.length >= 1;
    }

    public int traceConfigurationFavoriteCount(int traceConfigurationId) {
        return (Integer)this.activeObjects.executeInTransaction(() -> this.activeObjects.count(AccessControlAO.class, ActiveObjectz.buildWhereStr("OBJ", "OI", "ASPECT", "PTYPE"), new Object[]{"trace-configuration", Integer.toString(traceConfigurationId), FAVORITE_AO_ASPECT, "user"}));
    }

    public void deleteAllForTraceConfiguration(int traceConfigurationId) {
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.deleteWithSQL(AccessControlAO.class, ActiveObjectz.buildWhereStr("OBJ", "OI", "ASPECT", "PTYPE"), new Object[]{"trace-configuration", Integer.toString(traceConfigurationId), FAVORITE_AO_ASPECT, "user"});
            return null;
        });
    }

    public void unfavoriteTraceConfiguration(int traceConfigurationId, ApplicationUser user) {
        String userKey = user.getKey();
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.deleteWithSQL(AccessControlAO.class, ActiveObjectz.buildWhereStr("OBJ", "OI", "ASPECT", "PTYPE", "PID"), new Object[]{"trace-configuration", Integer.toString(traceConfigurationId), FAVORITE_AO_ASPECT, "user", userKey});
            return null;
        });
    }

    private static AccessControlAO[] find(ActiveObjects activeObjects, int traceConfigurationId, String userKey) {
        return (AccessControlAO[])activeObjects.find(AccessControlAO.class, ActiveObjectz.buildWhereStr("OBJ", "OI", "ASPECT", "PTYPE", "PID"), new Object[]{"trace-configuration", Integer.toString(traceConfigurationId), FAVORITE_AO_ASPECT, "user", userKey});
    }
}

