/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import io.vavr.Tuple2;
import io.vavr.collection.Stream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Providers<C> {
    private final Map<String, Provider<C>> providers;

    public Providers(List<Provider<C>> providers) {
        this.providers = Stream.ofAll(providers).toMap(provider -> new Tuple2<String, Provider>(provider.getKey(), (Provider)provider)).toJavaMap();
    }

    public Map<String, Object> fulfill(Collection<String> rawKeys, C context) {
        HashMap<String, Object> accumulator = new HashMap<String, Object>();
        Collection<String> keys = rawKeys == null || rawKeys.isEmpty() ? Stream.ofAll(this.providers.values()).map(Provider::getKey).toJavaList() : rawKeys;
        for (String key : keys) {
            Provider<C> provider = this.providers.get(key);
            if (provider == null) continue;
            provider.provideData(context, accumulator);
        }
        return accumulator;
    }

    public static interface Provider<C> {
        public String getKey();

        public void provideData(C var1, Map<String, Object> var2);
    }
}

