/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.collection.HashMap;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.trace.ao.MRUAO;

@Named
public class TraceConfigurationMRU {
    private static final int MRU_PRUNE_TO = 8;
    private static final int MRU_PRUNE_THRESHOLD = 16;
    private final ActiveObjects activeObjects;

    @Inject
    public TraceConfigurationMRU(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public List<MRUAO> getMRUs(ApplicationUser user) {
        List<MRUAO> mrus = this.get(user);
        if (mrus.size() < 16) {
            return mrus;
        }
        int excess = mrus.size() - 8;
        ActiveObjectz.deleteEntities(this.activeObjects, mrus.subList(8, mrus.size()).toArray(new MRUAO[excess]));
        return mrus.subList(0, 8);
    }

    public void updateOrInsert(int traceConfigurationId, ApplicationUser user) {
        String userKey = user.getKey();
        long timestamp = System.currentTimeMillis();
        this.activeObjects.executeInTransaction(() -> {
            boolean hasEntities;
            MRUAO[] entities = (MRUAO[])this.activeObjects.find(MRUAO.class, Query.select().where(ActiveObjectz.buildWhereStr("OT", "OI", "U"), new Object[]{"trace-configuration", Integer.toString(traceConfigurationId), userKey}));
            boolean bl = hasEntities = entities != null && entities.length >= 1;
            if (hasEntities) {
                MRUAO entity = entities[0];
                entity.setTimestamp(timestamp);
                entity.save();
                return null;
            }
            Map map = HashMap.of("OT", "trace-configuration", "OI", Integer.toString(traceConfigurationId), "U", userKey, "T", timestamp).toJavaMap();
            this.activeObjects.create(MRUAO.class, map);
            return null;
        });
    }

    public void deleteAllForTraceConfigurationId(int traceConfigurationId) {
        this.activeObjects.executeInTransaction(() -> {
            MRUAO[] entities = (MRUAO[])this.activeObjects.find(MRUAO.class, Query.select().where(ActiveObjectz.buildWhereStr("OT", "OI"), new Object[]{"trace-configuration", Integer.toString(traceConfigurationId)}));
            this.activeObjects.delete((RawEntity[])entities);
            return entities.length;
        });
    }

    public void deleteAllForUser(String userKey) {
        this.activeObjects.executeInTransaction(() -> {
            MRUAO[] entities = (MRUAO[])this.activeObjects.find(MRUAO.class, Query.select().where(ActiveObjectz.buildWhereStr("U"), new Object[]{userKey}));
            this.activeObjects.delete((RawEntity[])entities);
            return null;
        });
    }

    private List<MRUAO> get(ApplicationUser user) {
        String userKey = user.getKey();
        MRUAO[] entities = (MRUAO[])this.activeObjects.executeInTransaction(() -> (MRUAO[])this.activeObjects.find(MRUAO.class, Query.select().where(ActiveObjectz.buildWhereStr("OT", "U"), new Object[]{"trace-configuration", userKey}).order("T DESC")));
        ArrayList<MRUAO> res = new ArrayList<MRUAO>(entities.length);
        Collections.addAll(res, entities);
        return res;
    }
}

