/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.collection.HashMap;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import net.java.ao.Query;
import vivid.lib.Strings;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.trace.ao.ObjectKeyValueAO;
import vivid.trace.datatypes.ObjectKeyValue;

@Named
public class UserPreferences {
    private static final String DISTANCE_DEFAULT_VALUE = "3";
    public static final String INCLUDE_SEED_ISSUES_DEFAULT_VALUE = "true";
    private static final String SHOW_RELATIONSHIP_LABELS_OUTWARD_VALUE = "outward";
    private static final String SHOW_RELATIONSHIP_LABELS_DEFAULT_VALUE = "outward";
    private static final String DEFAULT_VIEWPORT_MODE_SCROLL_VALUE = "scroll";
    private static final String VIEWPORT_MODE_DEFAULT_VALUE = "scroll";
    private static final Map<String, String> DEFAULT_USER_PREFERENCES = HashMap.of("distance", "3", "includeSeedIssues", "true", "showRelationshipLabels", "outward", "viewport-mode", "scroll").toJavaMap();
    private final ActiveObjects activeObjects;
    private static final String DISTANCE_UNLIMITED_VALUE = "unlimited";

    @Inject
    public UserPreferences(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public Map<String, String> getUserPreferences(ApplicationUser user) {
        java.util.HashMap<String, String> settings = new java.util.HashMap<String, String>(DEFAULT_USER_PREFERENCES);
        String userKey = user.getKey();
        ObjectKeyValueAO[] entities = UserPreferences.find(this.activeObjects, userKey);
        if (entities != null) {
            for (ObjectKeyValueAO entity : entities) {
                UserPreferences._put__ao_to_interchange(settings, entity.getKey(), entity.getValue());
            }
        }
        return settings;
    }

    public void setUserPreferences(ApplicationUser user, Map<String, String> newSettings) {
        String userKey = user.getKey();
        for (Map.Entry<String, String> newSetting : newSettings.entrySet()) {
            this._updateOrCreate__interchange_to_ao(userKey, newSetting.getKey(), newSetting.getValue());
        }
    }

    private static ObjectKeyValueAO[] find(ActiveObjects activeObjects, String userKey) {
        return (ObjectKeyValueAO[])activeObjects.find(ObjectKeyValueAO.class, Query.select().where(ActiveObjectz.buildWhereStr("OT", "OI"), new Object[]{"user", userKey}));
    }

    private void updateOrCreate(String userKey, String dataKey, String dataValue) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, UserPreferences.userPreferenceCompositeKey(userKey, dataKey), dataValue);
    }

    private static ObjectKeyValue.CompositeKey userPreferenceCompositeKey(final String userKey, final String dataKey) {
        return new ObjectKeyValue.CompositeKey(){

            @Override
            public String getObjectType() {
                return "user";
            }

            @Override
            public String getObjectId() {
                return userKey;
            }

            @Override
            public String getKey() {
                return dataKey;
            }
        };
    }

    private static void _put__ao_to_interchange(Map<String, String> map, String key, String value) {
        if ("distance".equalsIgnoreCase(key) && DISTANCE_UNLIMITED_VALUE.equalsIgnoreCase(value)) {
            map.put("distance", "");
            return;
        }
        map.put(key, value);
    }

    private void _updateOrCreate__interchange_to_ao(String userKey, String key, String value) {
        boolean isUnlimitedDistance;
        boolean bl = isUnlimitedDistance = "distance".equalsIgnoreCase(key) && Strings.isBlank(value);
        if (isUnlimitedDistance) {
            this.updateOrCreate(userKey, "distance", DISTANCE_UNLIMITED_VALUE);
        } else {
            this.updateOrCreate(userKey, key, value);
        }
    }
}

