/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import io.vavr.Tuple;
import io.vavr.collection.HashMap;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.util.Arrays;
import java.util.Map;
import vivid.lib.I18n;
import vivid.lib.messages.VTE19InternalError;

public enum VersionComparator {
    BEFORE("lt", comparisonResult -> comparisonResult < 0),
    AT_MOST("le", comparisonResult -> comparisonResult <= 0),
    IS("eq", comparisonResult -> comparisonResult == 0),
    IS_NOT("ne", comparisonResult -> comparisonResult != 0),
    AT_LEAST("ge", comparisonResult -> comparisonResult >= 0),
    AFTER("gt", comparisonResult -> comparisonResult > 0);

    private static final Map<String, VersionComparator> NAME_MAP;
    private final String operatorName;
    private final transient Cmp cmp;

    private VersionComparator(String operatorName, Cmp cmp) {
        this.operatorName = operatorName;
        this.cmp = cmp;
    }

    public boolean compare(int comparisonResult) {
        return this.cmp.compare(comparisonResult);
    }

    public static VersionComparator fromString(String operatorName, Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        if (!NAME_MAP.containsKey(operatorName)) {
            throw new IllegalArgumentException(VTE19InternalError.message(i18nResolverAdapterOption, "There is no VersionComparator operator named '" + operatorName + "'").getMessage());
        }
        return NAME_MAP.get(operatorName);
    }

    static {
        NAME_MAP = HashMap.ofEntries(Stream.ofAll(Arrays.asList(VersionComparator.values())).map(value -> Tuple.of(value.operatorName, value))).toJavaMap();
    }

    private static interface Cmp {
        public boolean compare(int var1);
    }
}

