/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.customfield;

import java.util.EnumSet;

public enum Direction {
    PARENTS(1, "parents"),
    SUBTASKS(2, "subtasks"),
    INWARD_ISSUE_LINKS(4, "inward"),
    OUTWARD_ISSUE_LINKS(8, "outward");

    static final int NONE = 0;
    private final int encoding;
    private final String name;

    private Direction(int i, String name) {
        this.encoding = i;
        this.name = name;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static EnumSet<Direction> decode(Double directionsValue) {
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        int v = directionsValue.intValue();
        for (Direction d : Direction.values()) {
            if ((d.encoding & v) == 0) continue;
            set.add(d);
        }
        return set;
    }

    public static int encode(EnumSet<Direction> directions) {
        int v = 0;
        for (Direction direction : directions) {
            v |= direction.getEncoding();
        }
        return v;
    }

    public static boolean has(Double directionsValue, Direction direction) {
        int v = directionsValue.intValue();
        return (v & direction.encoding) == direction.encoding;
    }
}

