/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.data;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import javax.annotation.Nonnull;
import vivid.trace.datatypes.ObjectKeyValue;

@Named
public class ContextualTraceConfigurationQuickList {
    private final ActiveObjects activeObjects;
    public static final String CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST_AO_KEY = "contextual-trace-configuration-quick-list";
    private static final String CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST_FALLBACK_VALUE = "{}";
    private static final ObjectKeyValue.CompositeKey ADDON_COMPOSITE_KEY = new ObjectKeyValue.CompositeKey(){

        @Override
        public String getObjectType() {
            return "addon";
        }

        @Override
        public String getObjectId() {
            return "0";
        }

        @Override
        public String getKey() {
            return ContextualTraceConfigurationQuickList.CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST_AO_KEY;
        }
    };

    @Inject
    public ContextualTraceConfigurationQuickList(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Nonnull
    public Option<String> getAddonRawValue() {
        return ObjectKeyValue.getValue(this.activeObjects, ADDON_COMPOSITE_KEY);
    }

    @Nonnull
    public String getAddonComputedValue() {
        return this.getAddonRawValue().getOrElse(CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST_FALLBACK_VALUE);
    }

    public void setAddonValue(String value) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, ADDON_COMPOSITE_KEY, value);
    }

    private static ObjectKeyValue.CompositeKey projectCompositeKey(final Project project) {
        return new ObjectKeyValue.CompositeKey(){

            @Override
            public String getObjectType() {
                return "project";
            }

            @Override
            public String getObjectId() {
                return project.getId().toString();
            }

            @Override
            public String getKey() {
                return ContextualTraceConfigurationQuickList.CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST_AO_KEY;
            }
        };
    }

    public void deleteProjectValue(Project project) {
        ObjectKeyValue.delete(this.activeObjects, ContextualTraceConfigurationQuickList.projectCompositeKey(project));
    }

    @Nonnull
    public Option<String> getProjectRawValue(Project project) {
        return ObjectKeyValue.getValue(this.activeObjects, ContextualTraceConfigurationQuickList.projectCompositeKey(project));
    }

    @Nonnull
    public String getProjectComputedValue(Project project) {
        Option<String> projectValue = this.getProjectRawValue(project);
        return projectValue.isDefined() ? projectValue.get() : this.getAddonRawValue().getOrElse(CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST_FALLBACK_VALUE);
    }

    public void setProjectValue(Project project, String value) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, ContextualTraceConfigurationQuickList.projectCompositeKey(project), value);
    }

    private static ObjectKeyValue.CompositeKey userCompositeKey(final ApplicationUser applicationUser) {
        return new ObjectKeyValue.CompositeKey(){

            @Override
            public String getObjectType() {
                return "user";
            }

            @Override
            public String getObjectId() {
                return applicationUser.getKey();
            }

            @Override
            public String getKey() {
                return ContextualTraceConfigurationQuickList.CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST_AO_KEY;
            }
        };
    }

    @Nonnull
    public Option<String> getUserRawValue(ApplicationUser applicationUser) {
        return ObjectKeyValue.getValue(this.activeObjects, ContextualTraceConfigurationQuickList.userCompositeKey(applicationUser));
    }

    @Nonnull
    public String getUserComputedValue(ApplicationUser applicationUser) {
        Option<String> userValue = this.getUserRawValue(applicationUser);
        return userValue.isDefined() ? userValue.get() : this.getAddonRawValue().getOrElse(CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST_FALLBACK_VALUE);
    }

    public void setUserValue(ApplicationUser applicationUser, String value) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, ContextualTraceConfigurationQuickList.userCompositeKey(applicationUser), value);
    }
}

