/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.datatypes;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.role.ProjectRoleDeletedEvent;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Objects;
import vivid.trace.accesscontrols.AccessControls;
import vivid.trace.components.AbstractPluginLifecycle;
import vivid.trace.components.TraceConfigurationMRU;
import vivid.trace.datatypes.ObjectKeyValue;
import vivid.trace.datatypes.TraceConfigurations;

@ExportAsService(value={LifecycleAware.class})
@Named
public class JiraEventListenersForDatatypes
extends AbstractPluginLifecycle {
    private final AccessControls accessControls;
    private final ActiveObjects activeObjects;
    private final TraceConfigurations traceConfigurations;
    private final TraceConfigurationMRU traceConfigurationMRU;
    private final UserKeyService userKeyService;
    private final EventPublisher eventPublisher;

    @Inject
    public JiraEventListenersForDatatypes(AccessControls accessControls, @ComponentImport ActiveObjects activeObjects, @ComponentImport EventPublisher eventPublisher, TraceConfigurations traceConfigurations, TraceConfigurationMRU traceConfigurationMRU, @ComponentImport UserKeyService userKeyService) {
        super(eventPublisher);
        this.accessControls = accessControls;
        this.activeObjects = activeObjects;
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.traceConfigurations = traceConfigurations;
        this.traceConfigurationMRU = traceConfigurationMRU;
        this.userKeyService = userKeyService;
    }

    @Override
    protected void start() {
        this.eventPublisher.register((Object)this);
    }

    @Override
    protected void stop() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onGroupDeletedEvent(GroupDeletedEvent groupDeletedEvent) {
        this.accessControls.deletePrincipal("group", groupDeletedEvent.getGroupName());
    }

    @EventListener
    public void onProjectDeletedEvent(ProjectDeletedEvent projectDeletedEvent) {
        String projectId = projectDeletedEvent.getId().toString();
        this.accessControls.deleteObject("project", projectId);
        ObjectKeyValue.deleteObject(this.activeObjects, "project", projectId);
    }

    @EventListener
    public void onProjectRoleDeletedEvent(ProjectRoleDeletedEvent projectRoleDeletedEvent) {
        this.accessControls.deletePrincipal("project-role", projectRoleDeletedEvent.getProjectRole().getId().toString());
    }

    @EventListener
    public void onUserDeletedEvent(UserDeletedEvent userDeletedEvent) {
        String userKey = this.userKeyService.getKeyForUsername(userDeletedEvent.getUsername());
        if (userKey == null) {
            return;
        }
        this.accessControls.deletePrincipal("user", userKey);
        ObjectKeyValue.deleteObject(this.activeObjects, "user", userKey);
        this.traceConfigurationMRU.deleteAllForUser(userKey);
        this.traceConfigurations.eraseCreatedByThisUser(userKey);
    }
}

