/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.datatypes;

import com.atlassian.activeobjects.external.ActiveObjects;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.util.Map;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import vivid.lib.Primitives;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.trace.ao.ObjectKeyValueAO;

public class ObjectKeyValue {
    private ObjectKeyValue() {
    }

    public static void delete(ActiveObjects activeObjects, CompositeKey compositeKey) {
        activeObjects.executeInTransaction(() -> {
            activeObjects.delete((RawEntity[])ObjectKeyValue.find(activeObjects, compositeKey));
            return null;
        });
    }

    public static void deleteObject(ActiveObjects activeObjects, String objectType, String objectId) {
        activeObjects.executeInTransaction(() -> activeObjects.deleteWithSQL(ObjectKeyValueAO.class, ActiveObjectz.buildWhereStr("OT", "OI"), new Object[]{objectType, objectId}));
    }

    private static ObjectKeyValueAO[] find(ActiveObjects activeObjects, CompositeKey compositeKey) {
        return (ObjectKeyValueAO[])activeObjects.find(ObjectKeyValueAO.class, Query.select().where(ActiveObjectz.buildWhereStr("OT", "OI", "K"), new Object[]{compositeKey.getObjectType(), compositeKey.getObjectId(), compositeKey.getKey()}));
    }

    public static Option<String> getValue(ActiveObjects activeObjects, CompositeKey compositeKey) {
        return (Option)activeObjects.executeInTransaction(() -> {
            ObjectKeyValueAO[] entities = ObjectKeyValue.find(activeObjects, compositeKey);
            boolean hasEntities = entities != null && entities.length >= 1;
            return hasEntities ? Option.of(entities[0].getValue()) : Option.none();
        });
    }

    public static int getAsInt(ActiveObjects activeObjects, CompositeKey compositeKey, int defaultValue) {
        Option<Integer> v;
        Option<String> value = ObjectKeyValue.getValue(activeObjects, compositeKey);
        if (value.isDefined() && (v = Primitives.asInteger(value.get())).isDefined()) {
            return v.get();
        }
        return defaultValue;
    }

    public static void updateOrCreate(ActiveObjects activeObjects, CompositeKey compositeKey, String value) {
        activeObjects.executeInTransaction(() -> {
            boolean hasEntities;
            ObjectKeyValueAO[] entities = ObjectKeyValue.find(activeObjects, compositeKey);
            boolean bl = hasEntities = entities != null && entities.length >= 1;
            if (hasEntities) {
                ObjectKeyValueAO entity = entities[0];
                entity.setValue(value);
                entity.save();
                return null;
            }
            Map map = HashMap.of("OT", compositeKey.getObjectType(), "OI", compositeKey.getObjectId(), "K", compositeKey.getKey(), "V", value).toJavaMap();
            activeObjects.create(ObjectKeyValueAO.class, map);
            return null;
        });
    }

    public static interface CompositeKey {
        public String getObjectType();

        public String getObjectId();

        public String getKey();
    }
}

