/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.datatypes;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.lib.messages.Message;
import vivid.lib.messages.VTE19InternalError;
import vivid.trace.accesscontrols.TraceConfigurationAccessControl;
import vivid.trace.accesscontrols.TraceVisibilityAccessControl;
import vivid.trace.accesscontrols.UserACPrincipal;
import vivid.trace.ao.TraceConfigurationAO;
import vivid.trace.components.Factory;
import vivid.trace.components.Favorites;
import vivid.trace.components.Providers;
import vivid.trace.components.TraceConfigurationMRU;
import vivid.trace.jira.lib.Jira;

@Named
public class TraceConfigurations {
    public static final String ACL_JSON_KEY = "acl";
    public static final String CONFIGURATION_JSON_KEY = "configuration";
    public static final String CREATION_JSON_KEY = "creation";
    public static final String CREATOR_JSON_KEY = "creator";
    public static final String EFFECTIVE_ACCESS_JSON_KEY = "effective-access";
    public static final String FAVORITE_JSON_KEY = "favorite";
    public static final String FAVORITE_COUNT_JSON_KEY = "favorite-count";
    public static final String ID_JSON_KEY = "id";
    public static final String NAME_JSON_KEY = "name";
    public static final String TIMESTAMP_JSON_KEY = "timestamp";
    private final ActiveObjects activeObjects;
    private final Factory f;
    private final Favorites favorites;
    private final TraceConfigurationAccessControl traceConfigurationAccessControl;
    private final TraceConfigurationMRU traceConfigurationMRU;
    private static final Providers.Provider<Context> ACCESS_CONTROL_LIST = new Providers.Provider<Context>(){

        @Override
        public String getKey() {
            return TraceConfigurations.ACL_JSON_KEY;
        }

        @Override
        public void provideData(Context context, Map<String, Object> accumulator) {
            int id = context.traceConfigurationAO.getID();
            Collection<Map<String, String>> acl = context.traceConfigurationAccessControl.getAcl(id);
            accumulator.put(this.getKey(), TraceVisibilityAccessControl.embellishWithFields(acl, new TraceVisibilityAccessControl.OptionalFields[]{TraceVisibilityAccessControl.OptionalFields.NAME}, context.factory));
        }
    };
    private static final Providers.Provider<Context> CONFIGURATION = new Providers.Provider<Context>(){

        @Override
        public String getKey() {
            return TraceConfigurations.CONFIGURATION_JSON_KEY;
        }

        @Override
        public void provideData(Context context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), context.traceConfigurationAO.getConfiguration());
        }
    };
    private static final Providers.Provider<Context> CREATION = new Providers.Provider<Context>(){

        @Override
        public String getKey() {
            return TraceConfigurations.CREATION_JSON_KEY;
        }

        @Override
        public void provideData(Context context, Map<String, Object> accumulator) {
            java.util.HashMap<String, Object> data = new java.util.HashMap<String, Object>();
            String userKey = context.traceConfigurationAO.getCreatedBy();
            ApplicationUser user = context.factory.userManager.getUserByKey(userKey);
            Option<Map<String, String>> ud = UserACPrincipal.userData(user);
            if (ud.isDefined()) {
                data.put(TraceConfigurations.CREATOR_JSON_KEY, ud.get());
            }
            data.put(TraceConfigurations.TIMESTAMP_JSON_KEY, context.traceConfigurationAO.getCreationTimestamp());
            accumulator.put(this.getKey(), data);
        }
    };
    private static final Providers.Provider<Context> EFFECTIVE_ACCESS = new Providers.Provider<Context>(){

        @Override
        public String getKey() {
            return TraceConfigurations.EFFECTIVE_ACCESS_JSON_KEY;
        }

        @Override
        public void provideData(Context context, Map<String, Object> accumulator) {
            Option<TraceConfigurationAccessControl.TraceConfigurationAccess> effectiveAccess = context.traceConfigurationAccessControl.effectiveAccess(context.traceConfigurationAO.getID(), context.user);
            if (effectiveAccess.isDefined()) {
                accumulator.put(this.getKey(), effectiveAccess.get().toString());
            }
        }
    };
    private static final Providers.Provider<Context> FAVORITE = new Providers.Provider<Context>(){

        @Override
        public String getKey() {
            return TraceConfigurations.FAVORITE_JSON_KEY;
        }

        @Override
        public void provideData(Context context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), context.favorites.isTraceConfigurationFavorited(context.traceConfigurationAO.getID(), context.user));
        }
    };
    private static final Providers.Provider<Context> FAVORITE_COUNT = new Providers.Provider<Context>(){

        @Override
        public String getKey() {
            return TraceConfigurations.FAVORITE_COUNT_JSON_KEY;
        }

        @Override
        public void provideData(Context context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), context.favorites.traceConfigurationFavoriteCount(context.traceConfigurationAO.getID()));
        }
    };
    private static final Providers.Provider<Context> ID = new Providers.Provider<Context>(){

        @Override
        public String getKey() {
            return TraceConfigurations.ID_JSON_KEY;
        }

        @Override
        public void provideData(Context context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), context.traceConfigurationAO.getID());
        }
    };
    private static final Providers.Provider<Context> NAME = new Providers.Provider<Context>(){

        @Override
        public String getKey() {
            return TraceConfigurations.NAME_JSON_KEY;
        }

        @Override
        public void provideData(Context context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), context.traceConfigurationAO.getName());
        }
    };
    private static final Providers<Context> PROVIDERS = new Providers(Arrays.asList(ACCESS_CONTROL_LIST, CONFIGURATION, CREATION, EFFECTIVE_ACCESS, FAVORITE, FAVORITE_COUNT, ID, NAME));

    @Inject
    public TraceConfigurations(@ComponentImport ActiveObjects activeObjects, Factory f, Favorites favorites, TraceConfigurationAccessControl traceConfigurationAccessControl, TraceConfigurationMRU traceConfigurationMRU) {
        this.activeObjects = activeObjects;
        this.f = f;
        this.favorites = favorites;
        this.traceConfigurationAccessControl = traceConfigurationAccessControl;
        this.traceConfigurationMRU = traceConfigurationMRU;
    }

    public TraceConfigurationAO createTraceConfiguration(String traceConfiguration, String name, ApplicationUser user) {
        TraceConfigurationAO entity = this.create(traceConfiguration, name, user.getKey(), Instant.now().toEpochMilli());
        this.traceConfigurationAccessControl.set(entity.getID(), user, TraceConfigurationAccessControl.TraceConfigurationAccess.OWNER);
        this.favorites.favoriteTraceConfiguration(entity.getID(), user);
        this.traceConfigurationMRU.updateOrInsert(entity.getID(), user);
        return entity;
    }

    public TraceConfigurationAO createBundledTraceConfiguration(String traceConfiguration, String name) {
        TraceConfigurationAO entity = this.create(traceConfiguration, name, null, Instant.now().toEpochMilli());
        this.traceConfigurationAccessControl.setACL(Integer.toString(entity.getID()), Arrays.asList(HashMap.of("aspect", TraceConfigurationAccessControl.TraceConfigurationAccess.OWNER.toString(), "type", "system", ID_JSON_KEY, "owner").toJavaMap(), HashMap.of("aspect", TraceConfigurationAccessControl.TraceConfigurationAccess.VIEWER.toString(), "type", "system", ID_JSON_KEY, "everyone").toJavaMap()));
        return entity;
    }

    public void deleteTraceConfiguration(int id) {
        this.traceConfigurationMRU.deleteAllForTraceConfigurationId(id);
        this.favorites.deleteAllForTraceConfiguration(id);
        this.traceConfigurationAccessControl.delete(id);
        this.delete(id);
    }

    public Map<String, Object> getAsMap(ApplicationUser user, TraceConfigurationAO entity, Collection<String> keys) {
        Context context = new Context(user, this.favorites, entity, this.traceConfigurationAccessControl, this.f);
        return PROVIDERS.fulfill(keys, context);
    }

    public Option<TraceConfigurationAO> getTraceConfiguration(int traceConfigurationId, ApplicationUser user) {
        boolean hasAdminAccess;
        Option<TraceConfigurationAO> entity = this.get(traceConfigurationId);
        if (entity.isEmpty()) {
            return Option.none();
        }
        boolean bl = hasAdminAccess = user != null && Jira.hasJiraAdministratorsPermission(this.f.globalPermissionManager, user);
        if (!hasAdminAccess && !this.traceConfigurationAccessControl.canAccess(traceConfigurationId, user, TraceConfigurationAccessControl.TraceConfigurationAccess.VIEWER)) {
            return Option.none();
        }
        return entity;
    }

    public Collection<TraceConfigurationAO> listAllTraceConfigurations() {
        return Arrays.asList((TraceConfigurationAO[])this.activeObjects.executeInTransaction(() -> (TraceConfigurationAO[])this.activeObjects.find(TraceConfigurationAO.class)));
    }

    public Collection<TraceConfigurationAO> listVisibleTraceConfigurations(ApplicationUser user) {
        TraceConfigurationAO[] entities = (TraceConfigurationAO[])this.activeObjects.executeInTransaction(() -> (TraceConfigurationAO[])this.activeObjects.find(TraceConfigurationAO.class));
        ArrayList<TraceConfigurationAO> res = new ArrayList<TraceConfigurationAO>(entities.length);
        for (TraceConfigurationAO entity : entities) {
            if (!this.traceConfigurationAccessControl.canAccess(entity.getID(), user, TraceConfigurationAccessControl.TraceConfigurationAccess.VIEWER)) continue;
            res.add(entity);
        }
        return res;
    }

    public Option<Message> setAcl(String traceConfigurationId, Collection<Map<String, String>> acl) {
        Either<Message, Collection<Map<String, String>>> result = this.validateAcl(acl);
        if (result.isLeft()) {
            return Option.of(result.getLeft());
        }
        Collection<Map<String, String>> validatedACL = result.get();
        this.traceConfigurationAccessControl.setACL(traceConfigurationId, validatedACL);
        return Option.none();
    }

    public void updateTraceConfiguration(TraceConfigurationAO entity, ApplicationUser user) {
        this.traceConfigurationMRU.updateOrInsert(entity.getID(), user);
        this.update(entity);
    }

    private Either<Message, Collection<Map<String, String>>> validateAcl(Collection<Map<String, String>> acl) {
        if (acl == null || acl.isEmpty()) {
            return this.vte19ACLMustAppointAtLeastOneOwner();
        }
        if (acl.size() == 1) {
            Map<String, String> ace = acl.iterator().next();
            return Either.right(Collections.singletonList(((HashMap)HashMap.ofAll(ace).put((Object)"aspect", (Object)TraceConfigurationAccessControl.TraceConfigurationAccess.OWNER.toString())).toJavaMap()));
        }
        if (!this.traceConfigurationAccessControl.hasAtLeastOneOwner(acl)) {
            return this.vte19ACLMustAppointAtLeastOneOwner();
        }
        return Either.right(acl);
    }

    private Either<Message, Collection<Map<String, String>>> vte19ACLMustAppointAtLeastOneOwner() {
        return Either.left(VTE19InternalError.message(this.f.i18nResolverAdapterOption, "The ACL must appoint at least one owner."));
    }

    private TraceConfigurationAO create(String configuration, String name, String userKey, long creationTimestamp) {
        return (TraceConfigurationAO)this.activeObjects.executeInTransaction(() -> (TraceConfigurationAO)this.activeObjects.create(TraceConfigurationAO.class, HashMap.of("C", configuration, "N", name, "U", userKey, "T", creationTimestamp).toJavaMap()));
    }

    private void delete(int entityId) {
        this.activeObjects.executeInTransaction(() -> {
            TraceConfigurationAO[] entities = (TraceConfigurationAO[])this.activeObjects.find(TraceConfigurationAO.class, Query.select().where(ActiveObjectz.buildWhereStr("ID"), new Object[]{entityId}));
            this.activeObjects.delete((RawEntity[])entities);
            return entities.length;
        });
    }

    public void eraseCreatedByThisUser(String userKey) {
        this.activeObjects.executeInTransaction(() -> {
            TraceConfigurationAO[] entities;
            for (TraceConfigurationAO entity : entities = (TraceConfigurationAO[])this.activeObjects.find(TraceConfigurationAO.class, Query.select().where(ActiveObjectz.buildWhereStr("U"), new Object[]{userKey}))) {
                entity.setCreatedBy(null);
                entity.save();
            }
            return null;
        });
    }

    public Option<TraceConfigurationAO> get(int entityId) {
        return (Option)this.activeObjects.executeInTransaction(() -> {
            TraceConfigurationAO[] entities = (TraceConfigurationAO[])this.activeObjects.find(TraceConfigurationAO.class, Query.select().where(ActiveObjectz.buildWhereStr("ID"), new Object[]{entityId}));
            return entities != null && entities.length >= 1 ? Option.of(entities[0]) : Option.none();
        });
    }

    private void update(TraceConfigurationAO entity) {
        this.activeObjects.executeInTransaction(() -> {
            entity.save();
            return null;
        });
    }

    private static class Context {
        private final ApplicationUser user;
        private final Favorites favorites;
        private final TraceConfigurationAO traceConfigurationAO;
        private final TraceConfigurationAccessControl traceConfigurationAccessControl;
        private final Factory factory;

        private Context(ApplicationUser user, Favorites favorites, TraceConfigurationAO traceConfigurationAO, TraceConfigurationAccessControl traceConfigurationAccessControl, Factory factory) {
            this.user = user;
            this.favorites = favorites;
            this.traceConfigurationAO = traceConfigurationAO;
            this.traceConfigurationAccessControl = traceConfigurationAccessControl;
            this.factory = factory;
        }
    }
}

