/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jira.servlets;

import com.atlassian.jira.datetime.DateTimeFormatUtils;
import com.atlassian.jira.user.ApplicationUser;
import io.vavr.Tuple;
import io.vavr.collection.HashMap;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.stream.Collectors;
import vivid.lib.I18n;
import vivid.lib.atlassian.Servlets;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.VTE19InternalError;
import vivid.trace.components.Factory;
import vivid.trace.jira.gen.VividTraceForJiraProductIdentity;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jira.servlets.Static;

public class PageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String ACCESS_PERMISSION_PARAMETER_KEY = "access-permission";
    private static final String VELOCITY_TEMPLATE_PATH_PARAMETER_KEY = "velocity-template-path";
    protected final transient Factory f;
    protected Option<AccessPermission> accessPermission;
    private ServletConfig servletConfig;
    private Option<String> velocityTemplatePath;

    public PageServlet(Factory factory) {
        this.f = Objects.requireNonNull(factory);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
        this.velocityTemplatePath = Option.of(servletConfig.getInitParameter(VELOCITY_TEMPLATE_PATH_PARAMETER_KEY));
        this.accessPermission = PageServlet.getAccessPermissionInitParam(servletConfig);
    }

    private static Option<AccessPermission> getAccessPermissionInitParam(ServletConfig servletConfig) {
        String accessPermissionStr = servletConfig.getInitParameter(ACCESS_PERMISSION_PARAMETER_KEY);
        if (accessPermissionStr == null) {
            return Option.none();
        }
        return AccessPermission.NAME_MAP.get(accessPermissionStr);
    }

    boolean enforceAccessPermission(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.accessPermission.isEmpty()) {
            return true;
        }
        boolean isPermitted = false;
        if (this.accessPermission.get() == AccessPermission.JIRA_SYSTEM_ADMINISTRATOR) {
            isPermitted = Jira.hasJiraSystemAdministratorsPermission(this.f.globalPermissionManager, this.f.jiraAuthenticationContext.getLoggedInUser());
        } else if (this.accessPermission.get() == AccessPermission.JIRA_ADMINISTRATOR) {
            isPermitted = Jira.hasJiraAdministratorsPermission(this.f.globalPermissionManager, this.f.jiraAuthenticationContext.getLoggedInUser());
        }
        if (isPermitted) {
            Servlets.applyWebSudo(request, response, this.f.webSudoManager);
            return true;
        }
        Servlets.redirectToLogin(this.f.loginUriProvider, request, response);
        return false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.velocityTemplatePath.isEmpty()) {
                Servlets.renderMessagesToServletResponse(response, MessageSet.of(this.reportVTE19BadServletConfiguration(request)));
                return;
            }
            if (!this.enforceAccessPermission(request, response)) {
                return;
            }
            this.f.requireOwnWebResource("core-web-resources");
            Static.renderVelocityTemplateToServletResponse(response, this.velocityParams(request).toJavaMap(), this.velocityTemplatePath.get(), this.f);
        }
        catch (IOException e) {
            Servlets.renderMessagesToServletResponse(response, MessageSet.of(VTE19InternalError.message(this.f.i18nResolverAdapterOption, "Exception while processing request", e)));
        }
    }

    private Message reportVTE19BadServletConfiguration(HttpServletRequest request) {
        return VTE19InternalError.builder(this.f.i18nResolverAdapterOption, "Servlet init-param velocity-template-path is not configured correctly.", new Exception()).addDetail("request-url", request.getRequestURL().toString()).addDetail("request-method", request.getMethod()).addDetail("request-query-string", request.getQueryString()).addDetail("servlet-name", this.servletConfig.getServletName()).addDetail("servlet-config-params", this.servletConfigParamsMapAsString()).build();
    }

    private String servletConfigParamsMapAsString() {
        if (this.servletConfig == null) {
            return "{}";
        }
        Enumeration initParameterNames = this.servletConfig.getInitParameterNames();
        return Collections.list(initParameterNames).stream().map(k -> k + "=" + this.servletConfig.getInitParameter(k)).collect(Collectors.joining(", ", "{", "}"));
    }

    protected HashMap<String, Object> velocityParams(HttpServletRequest request) {
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        HashMap<String, Object> params = HashMap.of("i18n", I18n.i18nGetTextMethod(this.f.i18nResolverAdapterOption), "vt-date-time-format", DateTimeFormatUtils.getDateTimeFormat(), "vt-product-identity-release-date", this.addOnReleaseDate(), "vt-product-logo-url", this.productLogoUrl(), "vt-user-time-zone", Jira.timeZoneInfoForUser(user, this.f.timeZoneService).getTimeZoneId());
        return user != null ? params.put((Object)"vt-current-user-id", (Object)user.getKey()) : params;
    }

    private String addOnReleaseDate() {
        return Jira.formatDateForLoggedInUser(VividTraceForJiraProductIdentity.RELEASE_DATE, this.f.dateTimeFormatterFactory);
    }

    private String productLogoUrl() {
        return this.f.getStaticPluginResourceUrl("vivid.trace:relation-graph-web-resources", "images/add-on-logo-144x144.png");
    }

    static enum AccessPermission {
        JIRA_SYSTEM_ADMINISTRATOR("jira-system-administrator"),
        JIRA_ADMINISTRATOR("jira-administrator"),
        PROJECT_ADMINISTRATOR("project-administrator");

        private static final HashMap<String, AccessPermission> NAME_MAP;
        private final String label;

        private AccessPermission(String l) {
            this.label = l;
        }

        static {
            NAME_MAP = HashMap.ofEntries(Stream.ofAll(Arrays.asList(AccessPermission.values())).map(v -> Tuple.of(v.label, v)));
        }
    }
}

