/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jira.servlets;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import vivid.lib.atlassian.Servlets;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.VTE20UnknownObject;
import vivid.trace.components.Factory;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jira.servlets.PageServlet;

public class ProjectConfigurationPageServlet
extends PageServlet {
    public ProjectConfigurationPageServlet(Factory factory) {
        super(factory);
    }

    private void reportVTE20UnknownProject(HttpServletResponse response, Option<String> projectKey, Factory f) throws IOException {
        Servlets.renderMessagesToServletResponse(response, MessageSet.of(VTE20UnknownObject.message(f.i18nResolverAdapterOption, "vivid.phrase.project-key", projectKey.getOrElse("(EMPTY PROJECT KEY)"))));
    }

    @Override
    boolean enforceAccessPermission(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.accessPermission.get() == PageServlet.AccessPermission.PROJECT_ADMINISTRATOR) {
            Option<String> projectRaw = Servlets.firstPathInfoElement(request);
            if (projectRaw.isEmpty()) {
                this.reportVTE20UnknownProject(response, projectRaw, this.f);
                return false;
            }
            Either<MessageSet, Project> project = Jira.getProject(this.f, projectRaw.get(), Option.of(this.f.jiraAuthenticationContext.getLoggedInUser()));
            if (project.isLeft()) {
                Servlets.renderMessagesToServletResponse(response, project.getLeft());
                return false;
            }
            if (!this.f.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project.get(), this.f.jiraAuthenticationContext.getLoggedInUser())) {
                Servlets.redirectToLogin(this.f.loginUriProvider, request, response);
                return false;
            }
            return true;
        }
        return super.enforceAccessPermission(request, response);
    }

    @Override
    protected HashMap<String, Object> velocityParams(HttpServletRequest request) {
        Either<MessageSet, Project> project;
        HashMap<String, Object> params = super.velocityParams(request);
        Option<String> projectRaw = Servlets.firstPathInfoElement(request);
        if (projectRaw.isDefined() && (project = Jira.getProject(this.f, projectRaw.get(), Option.of(this.f.jiraAuthenticationContext.getLoggedInUser()))).isRight()) {
            return ((HashMap)((HashMap)params.put((Object)"vt-project-id", (Object)project.get().getId())).put("vt-project-key", project.get().getKey())).put("vt-project-name", project.get().getName());
        }
        return params;
    }
}

