/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jira.servlets;

import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import vivid.lib.Strings;
import vivid.lib.atlassian.Servlets;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.VTE19InternalError;
import vivid.trace.components.Factory;

public class RedirectServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String DOCS_PARAMETER_KEY = "docs";
    private final Factory f;
    private final Map<String, String> documentationPageUrls = HashMap.of("getting-started", "https://vivid-inc.net/vivid-trace/docs/2025.1/getting-started.html", "release-notes", "https://vivid-inc.net/vivid-trace/docs/2025.1/release-notes.html");

    public RedirectServlet(Factory factory) {
        this.f = factory;
    }

    private Object handleDocsKey(String keyRaw, HttpServletResponse response) {
        String k = keyRaw != null ? keyRaw.trim() : null;
        Option<String> url = this.documentationPageUrls.get(k);
        if (url.isEmpty()) {
            Servlets.responseWithMessage(response, Response.Status.BAD_REQUEST, VTE19InternalError.message(this.f.i18nResolverAdapterOption, "Unknown docs page '" + k + "' when attempting to redirect"));
            return null;
        }
        try {
            response.sendRedirect(url.get());
        }
        catch (IOException e) {
            Servlets.responseWithMessage(response, Response.Status.BAD_REQUEST, VTE19InternalError.message(this.f.i18nResolverAdapterOption, "Exception while attempting to send redirect to URL '" + url.get() + "'", e));
        }
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String key = request.getParameter(DOCS_PARAMETER_KEY);
        if (!Strings.isBlank(key)) {
            this.handleDocsKey(key, response);
        } else {
            Servlets.renderMessagesToServletResponse(response, MessageSet.of(VTE19InternalError.message(this.f.i18nResolverAdapterOption, "Unknown redirect key '" + key + "'")));
        }
    }
}

