/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jira.servlets;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class StableUrlFilter
implements Filter {
    private static final String DEFAULT_DOCUMENT_PATH_PARAMETER_KEY = "default-document-path";
    private static final String RESOURCE_BASE_URL_PARAMETER_KEY = "resource-url-base";
    private static final String STABLE_URL_BASE = "stable-url-base";
    private Option<String> defaultDocumentPath = Option.none();
    private Option<String> resourceBaseUrl = Option.none();
    private Option<String> stableBaseUrl = Option.none();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.defaultDocumentPath = Option.of(filterConfig.getInitParameter(DEFAULT_DOCUMENT_PATH_PARAMETER_KEY));
        this.resourceBaseUrl = Option.of(filterConfig.getInitParameter(RESOURCE_BASE_URL_PARAMETER_KEY));
        this.stableBaseUrl = Option.of(filterConfig.getInitParameter(STABLE_URL_BASE));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Option<Tuple2<String, Boolean>> nature = this.requestSubPath(request);
        if (nature.isEmpty()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String url = (String)nature.get()._1;
        boolean isRedirect = (Boolean)nature.get()._2;
        if (isRedirect) {
            response.sendRedirect(url);
        } else {
            request.getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private Option<Tuple2<String, Boolean>> requestSubPath(HttpServletRequest request) {
        String reqPath = request.getServletPath();
        if (!reqPath.startsWith(this.stableBaseUrl.get())) {
            return Option.none();
        }
        String resourceSubPath = reqPath.substring(this.stableBaseUrl.get().length());
        if (resourceSubPath.length() <= 0 || "/".equals(resourceSubPath)) {
            return Option.of(Tuple.of(request.getContextPath() + this.stableBaseUrl.get() + this.defaultDocumentPath.get(), true));
        }
        return Option.of(Tuple.of(this.resourceBaseUrl.get() + resourceSubPath, false));
    }

    public void destroy() {
    }
}

