/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jira.servlets;

import io.vavr.control.Option;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import vivid.lib.messages.VTE34InvalidXSRFToken;
import vivid.lib.rest.Rest;
import vivid.trace.components.Factory;

public class ValidateXsrfToken {
    private static final String ATLASSIAN_XSRF_TOKEN_COOKIE_KEY = "atlassian.xsrf.token";

    private ValidateXsrfToken() {
    }

    public static Collection<String> getXsrfTokenFromServletRequest(HttpServletRequest httpServletRequest) {
        return Arrays.stream(httpServletRequest.getCookies()).filter(c -> ATLASSIAN_XSRF_TOKEN_COOKIE_KEY.equalsIgnoreCase(c.getName())).map(Cookie::getValue).collect(Collectors.toList());
    }

    private static boolean skipXsrfTokenValidation(HttpServletRequest httpServletRequest) {
        String val = httpServletRequest.getHeader("X-Atlassian-Token");
        return "no-check".equals(val);
    }

    public static Option<Response> validateXsrfToken(HttpServletRequest httpServletRequest, Factory f) {
        if (ValidateXsrfToken.skipXsrfTokenValidation(httpServletRequest)) {
            return Option.none();
        }
        Collection<String> xsrfTokens = ValidateXsrfToken.getXsrfTokenFromServletRequest(httpServletRequest);
        for (String xsrfToken : xsrfTokens) {
            if (!f.xsrfTokenGenerator.validateToken(httpServletRequest, xsrfToken)) continue;
            return Option.none();
        }
        return Option.of(Rest.responseWithMessage(Response.Status.FORBIDDEN, VTE34InvalidXSRFToken.message(f.i18nResolverAdapterOption)));
    }
}

