/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.cs.fns;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.plugin.jql.function.ClauseSanitisingJqlFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import vivid.lib.I18n;
import vivid.lib.messages.VTE3JqlFunctionIncorrectFunctionUsage;
import vivid.trace.components.Factory;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jql.JqlMessageReportingAdapter;
import vivid.trace.jql.cs.params.IssuesParameter;
import vivid.trace.jql.cs.params.ProjectsParameter;
import vivid.trace.license.AddOnLicensing;

public abstract class AbstractCsJqlFunction
extends AbstractJqlFunction
implements ClauseSanitisingJqlFunction {
    protected static <T> Stream<T> itemsFromIssuesAndProjects(IssuesParameter issuesParameter, ProjectsParameter projectsParameter, ApplicationUser searcher, String jqlFunctionName, Factory factory, Function<Issue, Collection<T>> issueFunction, Function<Project, Collection<T>> projectFunction) {
        Collection<Issue> issues = issuesParameter.validate(Option.of(searcher), Option.none(), jqlFunctionName, factory);
        Collection<Project> projects = projectsParameter.validate(Option.of(searcher), Option.none(), jqlFunctionName, factory);
        if (!issues.isEmpty() || !projects.isEmpty()) {
            return Stream.concat(issues.stream().map(issueFunction).flatMap(Collection::stream), projects.stream().map(projectFunction).flatMap(Collection::stream));
        }
        return factory.projectManager.getProjects().stream().filter(p -> factory.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, p, searcher)).map(projectFunction).flatMap(Collection::stream);
    }

    public abstract String getFunctionUsageI18nKey();

    protected static MessageSet jiraMessageSetOfVTE3(Factory factory, String functionName, String functionUsageI18nKey) {
        return Jira.toJiraMessageSet(vivid.lib.messages.MessageSet.of(VTE3JqlFunctionIncorrectFunctionUsage.message(factory.i18nResolverAdapterOption, functionName, I18n.getText(factory.i18nResolverAdapterOption, functionUsageI18nKey, new Serializable[0]))));
    }

    protected static Option<String> sanitiseOperandIssueParameter(IssuesParameter issuesParameter, ApplicationUser searcher, String functionName, Factory factory) {
        Issue issue;
        Collection<Issue> issues = issuesParameter.validate(Option.none(), Option.none(), functionName, factory);
        if (!issues.isEmpty() && (issue = issues.iterator().next()) != null && !factory.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, searcher)) {
            return Option.of(issue.getId().toString());
        }
        return Option.none();
    }

    protected static Option<String> sanitiseOperandProjectParameter(ProjectsParameter projectsParameter, ApplicationUser searcher, String functionName, Factory factory) {
        Project project;
        Collection<Project> projects = projectsParameter.validate(Option.none(), Option.none(), functionName, factory);
        if (!projects.isEmpty() && (project = projects.iterator().next()) != null && !factory.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, searcher)) {
            return Option.of(project.getId().toString());
        }
        return Option.none();
    }

    @Nonnull
    protected static void validateAddOnLicensing(AddOnLicensing addOnLicensing, Factory factory, Option<vivid.lib.messages.MessageSet> messageSetOption, String functionName) {
        if (messageSetOption.isDefined() && !addOnLicensing.isAddOnLicenseValid(factory.i18nResolverAdapterOption)) {
            JqlMessageReportingAdapter adapter = new JqlMessageReportingAdapter(addOnLicensing, factory, functionName, Option.none());
            boolean hasAnyJiraGlobalAdminPermission = Jira.hasAnyJiraGlobalAdminPermission(factory.globalPermissionManager, factory.jiraAuthenticationContext.getLoggedInUser());
            adapter.reportAddOnUnlicensed(messageSetOption.get(), hasAnyJiraGlobalAdminPermission);
        }
    }
}

