/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.cs.fns;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.tree.ParseTree;
import vivid.trace.components.Factory;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jql.cs.fns.AbstractCsJqlFunction;
import vivid.trace.jql.cs.params.AbstractCsJqlFnsParameters;
import vivid.trace.jql.cs.params.ComponentLeadParameter;
import vivid.trace.jql.cs.params.ComponentStatusParameter;
import vivid.trace.jql.cs.params.IssuesParameter;
import vivid.trace.jql.cs.params.ProjectsParameter;
import vivid.trace.jql.grammar.CsJqlFnsParameterParser;

public class ComponentsJqlFunction
extends AbstractCsJqlFunction {
    private static final String FUNCTION_USAGE_I18N_KEY = "vivid.trace.jira.jql.cs.fn.components.usage";
    private final Factory factory;

    public ComponentsJqlFunction(Factory factory) {
        this.factory = factory;
    }

    private Parameters parseArgsIntoParameters(List<String> args, Option<vivid.lib.messages.MessageSet> messageSetOption) {
        Parameters parameters = new Parameters(this, messageSetOption);
        AbstractCsJqlFnsParameters.parseArgsIntoParameters(args, parameters, this, messageSetOption);
        return parameters;
    }

    @Nonnull
    public JiraDataType getDataType() {
        return JiraDataTypes.COMPONENT;
    }

    @Override
    public String getFunctionUsageI18nKey() {
        return FUNCTION_USAGE_I18N_KEY;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    @Nonnull
    public List<QueryLiteral> getValues(@Nonnull QueryCreationContext queryCreationContext, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        List args = functionOperand.getArgs();
        if (args.isEmpty()) {
            return new ArrayList<QueryLiteral>();
        }
        Parameters parameters = this.parseArgsIntoParameters(args, Option.none());
        ApplicationUser searcher = queryCreationContext.getApplicationUser();
        Stream<ProjectComponent> components = ComponentsJqlFunction.itemsFromIssuesAndProjects(parameters.issuesParameter, parameters.projectsParameter, searcher, this.getFunctionName(), this.factory, Issue::getComponents, Project::getComponents);
        Collection<ApplicationUser> leadUsers = parameters.componentLeadParameter.validate(Option.none(), this.getFunctionName(), this.factory);
        Set<ComponentStatusParameter.ComponentStatus> status = parameters.componentStatusParameter.validate();
        return components.filter(c -> leadUsers.isEmpty() || leadUsers.contains(c.getComponentLead())).filter(c -> status.isEmpty() || ComponentsJqlFunction.componentStatusPredicate(status, c)).map(ProjectComponent::getName).distinct().map(n -> new QueryLiteral((Operand)functionOperand, n)).collect(Collectors.toList());
    }

    private static boolean componentStatusPredicate(Set<ComponentStatusParameter.ComponentStatus> status, ProjectComponent c) {
        return status.contains((Object)ComponentStatusParameter.ComponentStatus.ARCHIVED) && c.isArchived() || status.contains((Object)ComponentStatusParameter.ComponentStatus.ACTIVE) && !c.isArchived() && !c.isDeleted() || status.contains((Object)ComponentStatusParameter.ComponentStatus.DELETED) && c.isDeleted();
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        List args = functionOperand.getArgs();
        if (args.isEmpty()) {
            return ComponentsJqlFunction.jiraMessageSetOfVTE3(this.factory, this.getFunctionName(), FUNCTION_USAGE_I18N_KEY);
        }
        Option<vivid.lib.messages.MessageSet> messageSetOption = Option.of(new vivid.lib.messages.MessageSet());
        Parameters parameters = this.parseArgsIntoParameters(args, messageSetOption);
        parameters.issuesParameter.validate(Option.of(searcher), messageSetOption, this.getFunctionName(), this.factory);
        parameters.componentLeadParameter.validate(messageSetOption, this.getFunctionName(), this.factory);
        parameters.projectsParameter.validate(Option.of(searcher), messageSetOption, this.getFunctionName(), this.factory);
        return Jira.toJiraMessageSet(messageSetOption.get());
    }

    @Nonnull
    public FunctionOperand sanitiseOperand(ApplicationUser searcher, @Nonnull FunctionOperand functionOperand) {
        List args = functionOperand.getArgs();
        boolean sanitised = false;
        ArrayList<String> sanitisedArgs = new ArrayList<String>(args.size());
        for (String arg : args) {
            Parameters parameters = this.parseArgsIntoParameters(Collections.singletonList(arg), Option.none());
            if (parameters.issuesParameter.hasValues()) {
                Option<String> sanitisedIssue = ComponentsJqlFunction.sanitiseOperandIssueParameter(parameters.issuesParameter, searcher, this.getFunctionName(), this.factory);
                if (!sanitisedIssue.isDefined()) continue;
                sanitisedArgs.add(sanitisedIssue.get());
                sanitised = true;
                continue;
            }
            if (parameters.projectsParameter.hasValues()) {
                Option<String> sanitisedProject = ComponentsJqlFunction.sanitiseOperandProjectParameter(parameters.projectsParameter, searcher, this.getFunctionName(), this.factory);
                if (!sanitisedProject.isDefined()) continue;
                sanitisedArgs.add(sanitisedProject.get());
                sanitised = true;
                continue;
            }
            sanitisedArgs.add(arg);
        }
        return sanitised ? new FunctionOperand(functionOperand.getName(), sanitisedArgs) : functionOperand;
    }

    class Parameters
    extends AbstractCsJqlFnsParameters {
        final IssuesParameter issuesParameter = new IssuesParameter();
        final ComponentLeadParameter componentLeadParameter = new ComponentLeadParameter();
        final ProjectsParameter projectsParameter = new ProjectsParameter();
        final ComponentStatusParameter componentStatusParameter = new ComponentStatusParameter();

        Parameters(ComponentsJqlFunction this$0, Option<vivid.lib.messages.MessageSet> messageSetOption) {
            super(this$0.factory, this$0, messageSetOption);
            super.registerParameters(io.vavr.collection.List.of(this.issuesParameter, this.componentLeadParameter, this.projectsParameter, this.componentStatusParameter));
        }

        @Override
        protected final ParseTree parseTree(CsJqlFnsParameterParser parser) {
            return parser.components_fn_parameter();
        }

        @Override
        public void exitIssue_p(CsJqlFnsParameterParser.Issue_pContext ctx) {
            this.issuesParameter.addParameterValue(ctx.getText());
        }

        @Override
        public void exitComponentLead(CsJqlFnsParameterParser.ComponentLeadContext ctx) {
            this.componentLeadParameter.addParameterValue(ctx.getText());
        }

        @Override
        public void exitProjectParameter(CsJqlFnsParameterParser.ProjectParameterContext ctx) {
            this.projectsParameter.addParameterValue(ctx.getText());
        }

        @Override
        public void exitComponentStatusActive(CsJqlFnsParameterParser.ComponentStatusActiveContext ctx) {
            this.componentStatusParameter.addParameterValue(ComponentStatusParameter.ComponentStatus.ACTIVE);
        }

        @Override
        public void exitComponentStatusArchived(CsJqlFnsParameterParser.ComponentStatusArchivedContext ctx) {
            this.componentStatusParameter.addParameterValue(ComponentStatusParameter.ComponentStatus.ARCHIVED);
        }

        @Override
        public void exitComponentStatusDeleted(CsJqlFnsParameterParser.ComponentStatusDeletedContext ctx) {
            this.componentStatusParameter.addParameterValue(ComponentStatusParameter.ComponentStatus.DELETED);
        }
    }
}

