/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.cs.fns;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import vivid.trace.components.Factory;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jql.cs.fns.AbstractCsJqlFunction;
import vivid.trace.jql.cs.fns.CurrentProjectJqlFunction;

public class CurrentProjectRolesJqlFunction
extends AbstractJqlFunction {
    private static final String FUNCTION_USAGE_I18N_KEY = "vivid.trace.jira.jql.cs.fn.current-project-roles.usage";
    private final Factory factory;
    private final UserProjectHistoryManager userProjectHistoryManager;

    public CurrentProjectRolesJqlFunction(Factory factory, @ComponentImport UserProjectHistoryManager userProjectHistoryManager) {
        this.factory = factory;
        this.userProjectHistoryManager = userProjectHistoryManager;
    }

    @Nonnull
    public JiraDataType getDataType() {
        return JiraDataTypes.PROJECT_ROLE;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    @Nonnull
    public List<QueryLiteral> getValues(@Nonnull QueryCreationContext queryCreationContext, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        ApplicationUser searcher = this.factory.jiraAuthenticationContext.getLoggedInUser();
        Option<Project> currentProjectOption = CurrentProjectJqlFunction.currentProjectForUser(searcher, this.userProjectHistoryManager);
        if (currentProjectOption.isEmpty()) {
            return Collections.emptyList();
        }
        Collection projectRoles = this.factory.projectRoleManager.getProjectRoles(searcher, currentProjectOption.get());
        if (projectRoles == null) {
            return Collections.emptyList();
        }
        return ((Stream)Stream.ofAll(projectRoles).map(r -> new QueryLiteral((Operand)functionOperand, r.getId()))).asJava();
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        List args = functionOperand.getArgs();
        if (!args.isEmpty()) {
            return AbstractCsJqlFunction.jiraMessageSetOfVTE3(this.factory, this.getFunctionName(), FUNCTION_USAGE_I18N_KEY);
        }
        return Jira.emptyJiraMessageSet();
    }
}

