/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.cs.fns;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.tree.ParseTree;
import vivid.lib.messages.MessageSet;
import vivid.trace.components.Factory;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jql.cs.fns.AbstractCsJqlFunction;
import vivid.trace.jql.cs.params.AbstractCsJqlFnsParameters;
import vivid.trace.jql.cs.params.IssuesParameter;
import vivid.trace.jql.cs.params.ProjectsParameter;
import vivid.trace.jql.cs.params.VersionStatusParameter;
import vivid.trace.jql.cs.params.VersionTypeParameter;
import vivid.trace.jql.grammar.CsJqlFnsParameterParser;

public class VersionsJqlFunction
extends AbstractCsJqlFunction {
    private static final String FUNCTION_USAGE_I18N_KEY = "vivid.trace.jira.jql.cs.fn.versions.usage";
    private final Factory factory;

    VersionsJqlFunction(Factory factory) {
        this.factory = factory;
    }

    private Parameters parseArgsIntoParameters(List<String> args, Option<MessageSet> messageSetOption) {
        Parameters parameters = new Parameters(this, messageSetOption);
        AbstractCsJqlFnsParameters.parseArgsIntoParameters(args, parameters, this, messageSetOption);
        return parameters;
    }

    @Nonnull
    public JiraDataType getDataType() {
        return JiraDataTypes.VERSION;
    }

    @Override
    public String getFunctionUsageI18nKey() {
        return FUNCTION_USAGE_I18N_KEY;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    @Nonnull
    public List<QueryLiteral> getValues(@Nonnull QueryCreationContext queryCreationContext, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        List args = functionOperand.getArgs();
        if (args.isEmpty()) {
            return new ArrayList<QueryLiteral>();
        }
        Parameters parameters = this.parseArgsIntoParameters(args, Option.none());
        ApplicationUser searcher = queryCreationContext.getApplicationUser();
        Set<VersionTypeParameter.VersionType> versionTypes = parameters.versionTypeParameter.validate();
        Stream<Version> versions = VersionsJqlFunction.itemsFromIssuesAndProjects(parameters.issuesParameter, parameters.projectsParameter, searcher, this.getFunctionName(), this.factory, i -> VersionsJqlFunction.issueVersionsOfType(versionTypes, i), Project::getVersions);
        Set<VersionStatusParameter.VersionStatus> status = parameters.versionStatusParameter.validate();
        return versions.filter(v -> VersionsJqlFunction.versionStatusPredicate(status, v)).map(Version::getName).distinct().map(n -> new QueryLiteral((Operand)functionOperand, n)).collect(Collectors.toList());
    }

    private static Collection<Version> issueVersionsOfType(Set<VersionTypeParameter.VersionType> versionTypes, Issue issue) {
        HashSet<Version> versions = new HashSet<Version>();
        if (versionTypes.isEmpty() || versionTypes.contains((Object)VersionTypeParameter.VersionType.AFFECTED)) {
            versions.addAll(issue.getAffectedVersions());
        }
        if (versionTypes.isEmpty() || versionTypes.contains((Object)VersionTypeParameter.VersionType.FIX)) {
            versions.addAll(issue.getFixVersions());
        }
        return versions;
    }

    private static boolean versionStatusPredicate(Set<VersionStatusParameter.VersionStatus> status, Version v) {
        return status.isEmpty() || status.contains((Object)VersionStatusParameter.VersionStatus.ARCHIVED) && v.isArchived() || status.contains((Object)VersionStatusParameter.VersionStatus.UNARCHIVED) && !v.isArchived() || status.contains((Object)VersionStatusParameter.VersionStatus.RELEASED) && v.isReleased() || status.contains((Object)VersionStatusParameter.VersionStatus.UNRELEASED) && !v.isReleased();
    }

    @Nonnull
    public com.atlassian.jira.util.MessageSet validate(ApplicationUser searcher, @Nonnull FunctionOperand functionOperand, @Nonnull TerminalClause terminalClause) {
        List args = functionOperand.getArgs();
        if (args.isEmpty()) {
            return VersionsJqlFunction.jiraMessageSetOfVTE3(this.factory, this.getFunctionName(), FUNCTION_USAGE_I18N_KEY);
        }
        Option<MessageSet> messageSetOption = Option.of(new MessageSet());
        Parameters parameters = this.parseArgsIntoParameters(args, messageSetOption);
        parameters.issuesParameter.validate(Option.of(searcher), messageSetOption, this.getFunctionName(), this.factory);
        parameters.projectsParameter.validate(Option.of(searcher), messageSetOption, this.getFunctionName(), this.factory);
        return Jira.toJiraMessageSet(messageSetOption.get());
    }

    @Nonnull
    public FunctionOperand sanitiseOperand(ApplicationUser searcher, @Nonnull FunctionOperand functionOperand) {
        List args = functionOperand.getArgs();
        boolean sanitised = false;
        ArrayList<String> sanitisedArgs = new ArrayList<String>(args.size());
        for (String arg : args) {
            Parameters parameters = this.parseArgsIntoParameters(Collections.singletonList(arg), Option.none());
            if (parameters.issuesParameter.hasValues()) {
                Option<String> sanitisedIssue = VersionsJqlFunction.sanitiseOperandIssueParameter(parameters.issuesParameter, searcher, this.getFunctionName(), this.factory);
                if (!sanitisedIssue.isDefined()) continue;
                sanitisedArgs.add(sanitisedIssue.get());
                sanitised = true;
                continue;
            }
            if (parameters.projectsParameter.hasValues()) {
                Option<String> sanitisedProject = VersionsJqlFunction.sanitiseOperandProjectParameter(parameters.projectsParameter, searcher, this.getFunctionName(), this.factory);
                if (!sanitisedProject.isDefined()) continue;
                sanitisedArgs.add(sanitisedProject.get());
                sanitised = true;
                continue;
            }
            sanitisedArgs.add(arg);
        }
        return sanitised ? new FunctionOperand(functionOperand.getName(), sanitisedArgs) : functionOperand;
    }

    class Parameters
    extends AbstractCsJqlFnsParameters {
        final IssuesParameter issuesParameter = new IssuesParameter();
        final ProjectsParameter projectsParameter = new ProjectsParameter();
        final VersionStatusParameter versionStatusParameter = new VersionStatusParameter();
        final VersionTypeParameter versionTypeParameter = new VersionTypeParameter();

        Parameters(VersionsJqlFunction this$0, Option<MessageSet> messageSetOption) {
            super(this$0.factory, this$0, messageSetOption);
            super.registerParameters(io.vavr.collection.List.of(this.issuesParameter, this.projectsParameter, this.versionStatusParameter, this.versionTypeParameter));
        }

        @Override
        protected final ParseTree parseTree(CsJqlFnsParameterParser parser) {
            return parser.versions_fn_parameter();
        }

        @Override
        public void exitIssue_p(CsJqlFnsParameterParser.Issue_pContext ctx) {
            this.issuesParameter.addParameterValue(ctx.getText());
        }

        @Override
        public void exitProjectParameter(CsJqlFnsParameterParser.ProjectParameterContext ctx) {
            this.projectsParameter.addParameterValue(ctx.getText());
        }

        @Override
        public void exitVersionStatusArchived(CsJqlFnsParameterParser.VersionStatusArchivedContext ctx) {
            this.versionStatusParameter.addParameterValue(VersionStatusParameter.VersionStatus.ARCHIVED);
        }

        @Override
        public void exitVersionStatusUnarchived(CsJqlFnsParameterParser.VersionStatusUnarchivedContext ctx) {
            this.versionStatusParameter.addParameterValue(VersionStatusParameter.VersionStatus.UNARCHIVED);
        }

        @Override
        public void exitVersionStatusReleased(CsJqlFnsParameterParser.VersionStatusReleasedContext ctx) {
            this.versionStatusParameter.addParameterValue(VersionStatusParameter.VersionStatus.RELEASED);
        }

        @Override
        public void exitVersionStatusUnreleased(CsJqlFnsParameterParser.VersionStatusUnreleasedContext ctx) {
            this.versionStatusParameter.addParameterValue(VersionStatusParameter.VersionStatus.UNRELEASED);
        }

        @Override
        public void exitVersionTypeAffected(CsJqlFnsParameterParser.VersionTypeAffectedContext ctx) {
            this.versionTypeParameter.addParameterValue(VersionTypeParameter.VersionType.AFFECTED);
        }

        @Override
        public void exitVersionTypeFix(CsJqlFnsParameterParser.VersionTypeFixContext ctx) {
            this.versionTypeParameter.addParameterValue(VersionTypeParameter.VersionType.FIX);
        }
    }
}

