/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.jql.cs.params;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import vivid.lib.I18n;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.VTE1JqlFunctionParameterValuesNotFound;
import vivid.trace.components.Factory;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jql.cs.params.Parameter;
import vivid.trace.jql.grammar.CsJqlFnsParameterParser;

public class IssuesParameter
implements Parameter<String> {
    private static final String ISSUE_PARAMETER_NAME = "issue";
    private static final String ISSUE_PARAMETER_USAGE_I18N_KEY = "vivid.trace.jira.jql.cs.param.issues.usage";
    private final List<String> issueLiterals = new ArrayList<String>();

    public boolean hasValues() {
        return !this.issueLiterals.isEmpty();
    }

    public String toString() {
        return "IssuesParameter" + String.valueOf(this.issueLiterals);
    }

    @Override
    public void addParameterValue(String issue) {
        this.issueLiterals.add(issue);
    }

    @Override
    public Class<? extends ParserRuleContext> parserRuleContext() {
        return CsJqlFnsParameterParser.ComponentIssueParameterContext.class;
    }

    @Override
    public String name() {
        return ISSUE_PARAMETER_NAME;
    }

    @Override
    public String usageI18nKey() {
        return ISSUE_PARAMETER_USAGE_I18N_KEY;
    }

    public Collection<Issue> validate(Option<ApplicationUser> searcher, Option<MessageSet> messageSetOption, String functionName, Factory factory) {
        ArrayList<Issue> v = new ArrayList<Issue>();
        ArrayList<String> inError = new ArrayList<String>();
        for (String i : this.issueLiterals) {
            Issue issue;
            Issue issue2 = issue = searcher.isDefined() ? Jira.issueForArg(i, searcher.get(), false, factory.jqlIssueSupport) : Jira.issueForArg(i, null, true, factory.jqlIssueSupport);
            if (issue != null) {
                v.add(issue);
                continue;
            }
            inError.add(i);
        }
        if (!inError.isEmpty()) {
            MessageSet.addMessageTo(messageSetOption, VTE1JqlFunctionParameterValuesNotFound.message(factory.i18nResolverAdapterOption, functionName, I18n.getText(factory.i18nResolverAdapterOption, "vivid.trace.phrase.issues", new Serializable[0]), inError));
        }
        return v;
    }
}

