/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.control.Either;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import vivid.lib.I18n;
import vivid.lib.Primitives;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.lib.messages.VTE26AuthenticationRequired;
import vivid.lib.messages.VTE27MalformedRequest;
import vivid.lib.messages.VTE28AccessDenied;
import vivid.lib.rest.Rest;
import vivid.trace.components.AddOnConfiguration;
import vivid.trace.components.AddOnPreconditions;
import vivid.trace.components.Factory;
import vivid.trace.components.Providers;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jira.servlets.ValidateXsrfToken;
import vivid.trace.rest.ProjectResource;

@Path(value="addon")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="addon", description="Vivid Trace for Jira add-on configuration")
public class AddOnResource {
    private final AddOnConfiguration addOnConfiguration;
    private final AddOnPreconditions addOnPreconditions;
    private final Factory f;
    @Context
    private HttpServletRequest httpServletRequest;
    private static final Providers.Provider<MyContext> GRAPH_TRAVERSAL_TIME_LIMIT = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "graph-traversal-time-limit";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), io.vavr.collection.HashMap.of("current", context.addOnResource.addOnConfiguration.getGraphTraversalTimeLimit(), "default", 3000).toJavaMap());
        }
    };
    private static final Providers.Provider<MyContext> ISSUE_COUNT_SOFT_MAXIMUM = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "issue-count-soft-maximum";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), io.vavr.collection.HashMap.of("current", context.addOnResource.addOnConfiguration.getIssueCountSoftMaximum(), "default", 1000).toJavaMap());
        }
    };
    private static final Providers.Provider<MyContext> MESSAGES = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "messages";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            MessageSet messages = context.addOnResource.addOnPreconditions.getViolationsOfTypes(context.addOnResource.f.newHtmlMessageReportingAdapter(), MessageType.ERROR, MessageType.WARNING);
            if (context.messageSet.isDefined()) {
                messages.addAll(context.messageSet.get());
            }
            accumulator.put(this.getKey(), messages.messages);
        }
    };
    private static final Providers.Provider<MyContext> ADDON_ISSUE_CONTEXT_TRACE_DISPLAY_FORMAT = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "issue-context-trace-display-format";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), context.addOnResource.addOnConfiguration.getIssueContextTraceDisplayFormat());
        }
    };
    private static final Providers.Provider<MyContext> ADDON_PROJECT_CONTEXTUAL_TRACE_VISIBILITY = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "trace-visibility";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            accumulator.put(this.getKey(), context.addOnResource.addOnConfiguration.getTraceVisibility());
        }
    };
    private static final Providers.Provider<MyContext> ADDON_CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST = new Providers.Provider<MyContext>(){

        @Override
        public String getKey() {
            return "contextual-trace-configuration-quick-list";
        }

        @Override
        public void provideData(MyContext context, Map<String, Object> accumulator) {
            String addonValue = context.addOnResource.addOnConfiguration.getContextualTraceConfigurationQuickList();
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("addon", addonValue);
            accumulator.put(this.getKey(), Collections.unmodifiableMap(res));
        }
    };
    private static final Providers<MyContext> PROVIDERS = new Providers(Arrays.asList(ADDON_CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST, ADDON_ISSUE_CONTEXT_TRACE_DISPLAY_FORMAT, ADDON_PROJECT_CONTEXTUAL_TRACE_VISIBILITY, GRAPH_TRAVERSAL_TIME_LIMIT, ISSUE_COUNT_SOFT_MAXIMUM, MESSAGES));

    @Inject
    public AddOnResource(AddOnConfiguration addOnConfiguration, AddOnPreconditions addOnPreconditions, Factory factory) {
        this.addOnConfiguration = addOnConfiguration;
        this.addOnPreconditions = addOnPreconditions;
        this.f = factory;
    }

    static Option<Response> permissionViolationResponse(Factory f) {
        if (!f.jiraAuthenticationContext.isLoggedInUser()) {
            return Option.of(Rest.responseWithMessage(Response.Status.UNAUTHORIZED, VTE26AuthenticationRequired.message(f.i18nResolverAdapterOption)));
        }
        if (!Jira.hasJiraSystemAdministratorsPermission(f.globalPermissionManager, f.jiraAuthenticationContext.getLoggedInUser())) {
            return Option.of(Rest.responseWithMessage(Response.Status.FORBIDDEN, VTE28AccessDenied.message(f.i18nResolverAdapterOption)));
        }
        return Option.none();
    }

    private Response currentAddOnConfiguration(List<String> keys, Option<MessageSet> messageSet) {
        MyContext context = new MyContext(this, messageSet);
        Map<String, Object> configuration = PROVIDERS.fulfill(keys, context);
        return Rest.responseWithJSONEntity(Response.Status.OK, configuration);
    }

    @GET
    @Operation(summary="Get add-on configuration settings", description="Get values of specific keys from the add-on configuration, or all settings if no keys are indicated. These settings apply system-wide. Unknown keys are ignored.", operationId="getAddOnConfiguration")
    @ApiResponse(responseCode="200", description="Add-on configuration for the specified keys", content={@Content(mediaType="application/json", schema=@Schema(type="string"))})
    public Response getAddOnConfiguration(@Parameter(description="Obtains values corresponding to these keys from the add-on configuration, or all keys when unspecified") @QueryParam(value="key") List<String> keys) {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        return this.currentAddOnConfiguration(keys, Option.none());
    }

    private static Either<Message, Integer> validateAddOnSettingValue(String parameterKey, String rawValue, Option<I18n.ResolverAdapter> i18nResolverAdapterOptional) {
        int value;
        Either<Message, Integer> valueOrMessage = Primitives.asIntegerOrMessage(parameterKey, rawValue, i18nResolverAdapterOptional);
        if (valueOrMessage.isRight() && (value = valueOrMessage.get().intValue()) <= 0) {
            return Either.left(VTE27MalformedRequest.message(i18nResolverAdapterOptional, "Add-on setting " + parameterKey + " parameter value must be 1 or larger."));
        }
        return valueOrMessage;
    }

    @PUT
    @Operation(summary="Sets specific key-value settings in the add-on configuration", operationId="setAddOnConfiguration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The updated add-on configuration for the specified keys. Even if there were failures, HTTP status 200 is returned along with descriptive messages.", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="401", description="Authentication is required to proceed"), @ApiResponse(responseCode="403", description="Lacking Jira System Administrator privilege")})
    @SecurityRequirement(name="jira-administer-project")
    public Response setAddOnConfiguration(@RequestBody(description="Changed portions of the project trace configuration", required=true, content={@Content(schema=@Schema(implementation=AddOnConfigurationData.class))}) String deltaStr) throws IOException {
        int value;
        Either<Message, Integer> valueOrMessage;
        String rawValue;
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Option<Response> responseOptional = AddOnResource.permissionViolationResponse(this.f);
        if (responseOptional.isDefined()) {
            return responseOptional.get();
        }
        Map<String, Object> delta = Jackson.readValue(deltaStr != null ? deltaStr : "{}", new Jackson.TypeReference<Map<String, Object>>(this){});
        MessageSet messages = new MessageSet();
        if (delta.containsKey("issue-context-trace-display-format")) {
            rawValue = (String)delta.get("issue-context-trace-display-format");
            if (rawValue == "issuetabpanel" || rawValue == "webpanel") {
                messages.add(VTE27MalformedRequest.message(this.f.i18nResolverAdapterOption, "issue-context-trace-display-format must be one of: issuetabpanel, webpanel"));
            } else {
                this.addOnConfiguration.setIssueContextTraceDisplayFormat(rawValue);
            }
        }
        if (delta.containsKey("issue-count-soft-maximum")) {
            rawValue = (String)delta.get("issue-count-soft-maximum");
            valueOrMessage = AddOnResource.validateAddOnSettingValue("issue-count-soft-maximum", rawValue, this.f.i18nResolverAdapterOption);
            if (valueOrMessage.isLeft()) {
                messages.add(valueOrMessage.getLeft());
            } else {
                value = valueOrMessage.get();
                this.addOnConfiguration.setIssueCountSoftMaximum(value);
            }
        }
        if (delta.containsKey("graph-traversal-time-limit")) {
            rawValue = (String)delta.get("graph-traversal-time-limit");
            valueOrMessage = AddOnResource.validateAddOnSettingValue("graph-traversal-time-limit", rawValue, this.f.i18nResolverAdapterOption);
            if (valueOrMessage.isLeft()) {
                messages.add(valueOrMessage.getLeft());
            } else {
                value = valueOrMessage.get();
                this.addOnConfiguration.setGraphTraversalTimeLimit(value);
            }
        }
        if (delta.containsKey("trace-visibility")) {
            this.addOnConfiguration.setTraceVisibility((Collection)delta.get("trace-visibility"));
        }
        if (delta.containsKey("contextual-trace-configuration-quick-list")) {
            this.addOnConfiguration.setContextualTraceConfigurationQuickList((String)delta.get("contextual-trace-configuration-quick-list"));
        }
        return this.currentAddOnConfiguration(new ArrayList<String>(), Option.of(messages));
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Operation(summary="Reset add-on configuration settings", description="Reset specific settings in the add-on configuration to their default values.", operationId="resetAddOnConfiguration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The updated add-on configuration for the specified keys.", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="401", description="Authentication is required to proceed"), @ApiResponse(responseCode="403", description="Lacking Jira System Administrator privilege")})
    @SecurityRequirement(name="jira-system-administrator")
    public Response resetAddOnConfiguration(@Parameter(description="Reset the values of these system-wide add-on configuration settings") @QueryParam(value="key") List<String> keys) {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Option<Response> responseOptional = AddOnResource.permissionViolationResponse(this.f);
        if (responseOptional.isDefined()) {
            return responseOptional.get();
        }
        if (keys != null) {
            if (keys.contains("issue-count-soft-maximum")) {
                this.addOnConfiguration.resetIssueCountSoftMaximum();
            }
            if (keys.contains("graph-traversal-time-limit")) {
                this.addOnConfiguration.resetGraphTraversalTimeLimit();
            }
            if (keys.contains("trace-visibility")) {
                this.addOnConfiguration.resetTraceVisibility();
            }
        }
        return this.currentAddOnConfiguration(keys, Option.none());
    }

    private static class MyContext {
        final AddOnResource addOnResource;
        final Option<MessageSet> messageSet;

        private MyContext(AddOnResource addOnResource, Option<MessageSet> messageSet) {
            this.addOnResource = addOnResource;
            this.messageSet = messageSet;
        }
    }

    @Schema(description="Configuration of the Vivid Trace for Jira add-on")
    private static class AddOnConfigurationData {
        @Schema(name="contextual-trace-configuration-quick-list")
        String contextualTraceConfigurationQuickList;
        @Schema(name="graph-traversal-time-limit")
        String graphTraversalTimeLimit;
        @Schema(name="issue-context-trace-display-format")
        ProjectResource.IssueContextTraceDisplayFormat issueContextTraceDisplayFormat;
        @Schema(name="issue-count-soft-maximum")
        String issueCountSoftMaximum;
        @Schema(name="trace-visibility")
        List<ProjectResource.Principal> traceVisibility;

        private AddOnConfigurationData() {
        }

        public String getContextualTraceConfigurationQuickList() {
            return this.contextualTraceConfigurationQuickList;
        }

        public String getGraphTraversalTimeLimit() {
            return this.graphTraversalTimeLimit;
        }

        public ProjectResource.IssueContextTraceDisplayFormat getIssueContextTraceDisplayFormat() {
            return this.issueContextTraceDisplayFormat;
        }

        public String getIssueCountSoftMaximum() {
            return this.issueCountSoftMaximum;
        }

        public List<ProjectResource.Principal> getTraceVisibility() {
            return this.traceVisibility;
        }
    }
}

