/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.collection.HashMap;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.Map;
import vivid.lib.messages.CodedMessage;
import vivid.lib.rest.OpenAPIDefinitionCache;
import vivid.lib.rest.Rest;
import vivid.trace.components.Factory;
import vivid.trace.jira.gen.VividTraceForJiraProductIdentity;
import vivid.trace.license.AddOnLicensing;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="addon", description="Vivid Trace for Jira add-on configuration")
public class RootResource {
    private final AddOnLicensing addOnLicensing;
    private final Factory f;
    private static final String VIVID_TRACE_JIRA_ADDON_OPENAPI_DEFINITION_RESOURCE_PATH = "/openapi/vivid-trace-jira-addon-openapi.json";
    private static final HashMap<String, Object> IDENTITY_MAP = HashMap.of("product-full-name", "Vivid Trace for Jira", "product-name", "Vivid Trace", "product-version", "2025.1.1", "release-date", VividTraceForJiraProductIdentity.RELEASE_DATE, "rest-api-versions", VividTraceForJiraProductIdentity.REST_API_VERSIONS, "vcs", "Git d09bbdf05f69");

    @Inject
    public RootResource(AddOnLicensing addOnLicensing, Factory factory) {
        this.addOnLicensing = addOnLicensing;
        this.f = factory;
    }

    @Path(value="api")
    @GET
    @Operation(summary="Vivid Trace for Jira OpenAPI definition", operationId="api")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Vivid Trace for Jira OpenAPI definition", content={@Content(schema=@Schema(implementation=String.class, format="application/json"))}), @ApiResponse(responseCode="500", description="Could not produce the Vivid Trace for Jira OpenAPI definition", content={@Content(schema=@Schema(implementation=CodedMessage.class))})})
    public Response getOpenAPIDefinition(@Context UriInfo uriInfo) {
        return OpenAPIDefinitionCache.getOpenAPIDefinition(this.f.i18nResolverAdapterOption, uriInfo, VIVID_TRACE_JIRA_ADDON_OPENAPI_DEFINITION_RESOURCE_PATH);
    }

    @Path(value="identity")
    @GET
    @Operation(summary="Information identifying this release of Vivid Trace for Jira", operationId="identity")
    @ApiResponse(responseCode="200", description="Vivid Trace for Jira release identity info", content={@Content(schema=@Schema(implementation=Map.class))})
    public Response getIdentity() {
        Map<String, Object> data = this.addOnLicensing.licensingStatus(Collections.singletonList("messages"));
        data.putAll(IDENTITY_MAP.toJavaMap());
        return Rest.responseWithJSONEntity(Response.Status.OK, data);
    }
}

