/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.rest;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import vivid.lib.messages.VTE28AccessDenied;
import vivid.lib.rest.Rest;
import vivid.trace.accesscontrols.GroupACPrincipal;
import vivid.trace.accesscontrols.ProjectRoleACPrincipal;
import vivid.trace.accesscontrols.UserACPrincipal;
import vivid.trace.components.Factory;
import vivid.trace.components.Providers;
import vivid.trace.ifc.ItemFields;
import vivid.trace.jira.servlets.ValidateXsrfToken;

@Path(value="system")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="system", description="Information sourced from the host platform")
public class SystemResource {
    private final Factory f;
    @Context
    private HttpServletRequest httpServletRequest;
    private static final Providers<Factory> PROVIDERS = new Providers(Arrays.asList(new GroupACPrincipal(), new ItemFields(), new ProjectRoleACPrincipal(), new UserACPrincipal()));

    @Inject
    public SystemResource(Factory factory) {
        this.f = factory;
    }

    @GET
    @Operation(summary="Retrieve data from various Jira data sources", operationId="getJiraSystemData")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request succeeded: Replying with data"), @ApiResponse(responseCode="403", description="Refusing access to requested resource, perhaps due to insufficient privilege (Caller is assumed to know that the resource might exist)")})
    public Response getJiraSystemData(@Parameter(description="Jira system data of interest", required=true, array=@ArraySchema(schema=@Schema(type="string", allowableValues={"item-fields", "group", "project-role", "user"}))) @QueryParam(value="key") List<String> keys) {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        if (user == null) {
            return Rest.responseWithMessage(Response.Status.FORBIDDEN, VTE28AccessDenied.message(this.f.i18nResolverAdapterOption));
        }
        Map<String, Object> data = PROVIDERS.fulfill(keys, this.f);
        return Rest.responseWithJSONEntity(Response.Status.OK, data);
    }

    @Path(value="jql")
    @GET
    @Operation(summary="Validate a JQL query string", description="Validates a JQL (\"Jira Query Language\") query string. Useful for providing live feedback.", operationId="validateJql")
    @ApiResponse(responseCode="200", description="Boolean indication of whether the supplied JQL query string is valid or not")
    public Response validateJql(@Parameter(description="A JQL query string", required=true, schema=@Schema(type="string")) @QueryParam(value="jql") String jqlString) {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        SearchService.ParseResult parseResult = this.f.searchService.parseQuery(this.f.jiraAuthenticationContext.getLoggedInUser(), jqlString);
        boolean isValidJqlString = parseResult.isValid();
        Map ret = HashMap.of("valid", isValidJqlString).toJavaMap();
        return Rest.responseWithJSONEntity(Response.Status.OK, ret);
    }
}

