/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.rest;

import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.control.Either;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vivid.lib.Primitives;
import vivid.lib.ResponseAdapter;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.Message;
import vivid.lib.messages.VTE20UnknownObject;
import vivid.lib.messages.VTE33AccessDenied;
import vivid.lib.rest.Rest;
import vivid.lib.rest.RestResponseAdapter;
import vivid.trace.accesscontrols.TraceConfigurationAccessControl;
import vivid.trace.ao.MRUAO;
import vivid.trace.ao.TraceConfigurationAO;
import vivid.trace.components.Factory;
import vivid.trace.components.Favorites;
import vivid.trace.components.TraceConfigurationMRU;
import vivid.trace.datatypes.TraceConfigurations;
import vivid.trace.jira.lib.Jira;
import vivid.trace.jira.servlets.ValidateXsrfToken;
import vivid.trace.rest.ProjectResource;

@Path(value="trace")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="trace", description="Trace configurations")
public class TraceConfigurationResource {
    private static final String MRU_PATH_SEGMENT = "mru";
    private static final String TRACE_ID_ERROR_MESSAGE_NAME = "trace ID";
    private final Factory f;
    private final Favorites favorites;
    @Context
    private HttpServletRequest httpServletRequest;
    private final TraceConfigurationAccessControl traceConfigurationAccessControl;
    private final TraceConfigurations traceConfigurations;
    private final TraceConfigurationMRU traceConfigurationMRU;
    public static final String ALL_KEY = "all";

    @Inject
    public TraceConfigurationResource(Factory factory, Favorites favorites, TraceConfigurationAccessControl traceConfigurationAccessControl, TraceConfigurations traceConfigurations, TraceConfigurationMRU traceConfigurationMRU) {
        this.f = factory;
        this.favorites = favorites;
        this.traceConfigurationAccessControl = traceConfigurationAccessControl;
        this.traceConfigurations = traceConfigurations;
        this.traceConfigurationMRU = traceConfigurationMRU;
    }

    @GET
    @Operation(summary="List of all saved traces accessible to the currently authenticated user.", description="'AND' semantic is applied to parameters to filter the result set.", operationId="getTraceConfigurations")
    @ApiResponse(responseCode="200", description="Request succeeded: Replying with data")
    public Response getTraceConfigurations(@Parameter(description="Return only those trace configurations that are favorited by the caller") @DefaultValue(value="false") @QueryParam(value="favorite") boolean favoriteOnly, @Parameter(description="Return only those trace configurations with these IDs") @QueryParam(value="id") List<String> ids, @Parameter(description="Obtains values corresponding to these keys from the trace configuration, or all keys when unspecified") @QueryParam(value="key") List<String> keys) {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        Collection<TraceConfigurationAO> entities = Jira.hasJiraAdministratorsPermission(this.f.globalPermissionManager, user) ? this.traceConfigurations.listAllTraceConfigurations() : this.traceConfigurations.listVisibleTraceConfigurations(user);
        HashMap<Integer, Map<String, Object>> res = new HashMap<Integer, Map<String, Object>>(entities.size());
        for (TraceConfigurationAO entity : entities) {
            if (favoriteOnly && !this.favorites.isTraceConfigurationFavorited(entity.getID(), user)) continue;
            String idAsString = String.valueOf(entity.getID());
            if (!ids.isEmpty() && !ids.contains(idAsString)) continue;
            res.put(entity.getID(), this.traceConfigurations.getAsMap(user, entity, keys));
        }
        return Rest.responseWithJSONEntity(Response.Status.OK, Collections.singletonMap("trace-configurations", res));
    }

    @POST
    @Operation(summary="Save a new trace configuration", description="The supplied trace configuration is always saved with a new ID. Names may overlap.", operationId="createTraceConfiguration")
    @ApiResponse(responseCode="200", description="Returns the ID of the new trace configuration")
    public Response createTraceConfiguration(@RequestBody(description="New trace configuration", required=true, content={@Content(schema=@Schema(type="string", format="Trace configuration"))}) String json) throws IOException {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        Map<String, String> configuration = Jackson.readValue(json, new Jackson.TypeReference<Map<String, String>>(this){});
        TraceConfigurationAO entity = this.traceConfigurations.createTraceConfiguration(configuration.get("configuration"), configuration.get("name"), user);
        Map<String, Object> res = this.traceConfigurations.getAsMap(user, entity, Collections.emptyList());
        return Rest.responseWithJSONEntity(Response.Status.OK, res);
    }

    @Path(value="{id}")
    @GET
    @Operation(summary="Retrieve a trace configuration by ID", description="Retrieve a trace configuration by its ID. Configurable as either JSON or standalone HTML.", operationId="getTraceConfiguration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Trace configuration, in either JSON or as standalone HTML"), @ApiResponse(responseCode="400", description="Request could not be interpreted, contained invalid or unusable data, or product license is invalid, or some other condition"), @ApiResponse(responseCode="404", description="Requested resource was not found")})
    @Produces(value={"application/json", "text/html"})
    public Response getTraceConfiguration(@Parameter(description="ID of the trace configuration", required=true, schema=@Schema(type="string", format="integer")) @PathParam(value="id") String traceConfigurationId, @Parameter(description="Obtains values corresponding to these keys from the trace configuration, or all keys when unspecified") @QueryParam(value="key") List<String> keys) {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Either<Response, TraceConfigurationAO> traceConfigurationAOOrVTE20Response = TraceConfigurationResource.produceTraceConfigurationAOOrVTE20(RestResponseAdapter.INSTANCE, traceConfigurationId, this.traceConfigurations, this.f);
        if (traceConfigurationAOOrVTE20Response.isLeft()) {
            return traceConfigurationAOOrVTE20Response.getLeft();
        }
        TraceConfigurationAO traceConfigurationAO = traceConfigurationAOOrVTE20Response.get();
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        this.traceConfigurationMRU.updateOrInsert(traceConfigurationAO.getID(), user);
        return this.traceConfigurationAsJSONResponse(traceConfigurationAO, keys);
    }

    private Response traceConfigurationAsJSONResponse(TraceConfigurationAO traceConfigurationAO, Collection<String> keys) {
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        Map<String, Object> traceConfigurationData = this.traceConfigurations.getAsMap(user, traceConfigurationAO, keys);
        return Rest.responseWithJSONEntity(Response.Status.OK, traceConfigurationData);
    }

    private static Set<String> responseKeys(Collection<String> specifiedKeys, Collection<String> requestedKeys) {
        if (requestedKeys.contains(ALL_KEY)) {
            return Collections.emptySet();
        }
        HashSet<String> keys = new HashSet<String>(specifiedKeys);
        if (!requestedKeys.isEmpty()) {
            keys.addAll(requestedKeys);
        }
        return keys;
    }

    @Path(value="{id}")
    @PUT
    @Operation(summary="Update an existing trace configuration", operationId="setTraceConfiguration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The updated trace configuration for the specified keys", content={@Content(mediaType="application/json", schema=@Schema(type="string"))}), @ApiResponse(responseCode="404", description="Requested resource was not found")})
    public Response setTraceConfiguration(@Parameter(description="Trace configuration ID", required=true, schema=@Schema(type="string", format="integer")) @PathParam(value="id") String entityId, @RequestBody(description="Trace configuration JSON", required=true, content={@Content(schema=@Schema(implementation=TraceConfiguration.class))}) String json, @Parameter(description="Response includes values of those keys used in the request plus these keys") @QueryParam(value="key") List<String> keys) throws IOException {
        Option<Response> accessDeniedResponse;
        boolean administratorOverride;
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Either<Response, TraceConfigurationAO> traceConfigurationAOOrResponse = TraceConfigurationResource.produceTraceConfigurationAOOrVTE20(RestResponseAdapter.INSTANCE, entityId, this.traceConfigurations, this.f);
        if (traceConfigurationAOOrResponse.isLeft()) {
            return traceConfigurationAOOrResponse.getLeft();
        }
        TraceConfigurationAO entity = traceConfigurationAOOrResponse.get();
        Map<String, Object> delta = Jackson.readValue(json != null ? json : "{}", new Jackson.TypeReference<Map<String, Object>>(this){});
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        Option<TraceConfigurationAccessControl.TraceConfigurationAccess> effectiveAccess = this.traceConfigurationAccessControl.effectiveAccess(entity.getID(), user);
        boolean bl = administratorOverride = user != null && Jira.hasJiraAdministratorsPermission(this.f.globalPermissionManager, user);
        if (delta.containsKey("configuration")) {
            if (!administratorOverride && (accessDeniedResponse = this.renderVTE33ResponseIfInsufficientAccess(effectiveAccess, TraceConfigurationAccessControl.TraceConfigurationAccess.EDITOR, entityId)).isDefined()) {
                return accessDeniedResponse.get();
            }
            entity.setConfiguration((String)delta.get("configuration"));
        }
        if (delta.containsKey("name")) {
            if (!administratorOverride && (accessDeniedResponse = this.renderVTE33ResponseIfInsufficientAccess(effectiveAccess, TraceConfigurationAccessControl.TraceConfigurationAccess.OWNER, entityId)).isDefined()) {
                return accessDeniedResponse.get();
            }
            entity.setName((String)delta.get("name"));
        }
        if (delta.containsKey("configuration") || delta.containsKey("name")) {
            this.traceConfigurations.updateTraceConfiguration(entity, this.f.jiraAuthenticationContext.getLoggedInUser());
        }
        if (delta.containsKey("acl")) {
            if (!administratorOverride && (accessDeniedResponse = this.renderVTE33ResponseIfInsufficientAccess(effectiveAccess, TraceConfigurationAccessControl.TraceConfigurationAccess.OWNER, entityId)).isDefined()) {
                return accessDeniedResponse.get();
            }
            Collection acl = (Collection)delta.get("acl");
            Option<Message> result = this.traceConfigurations.setAcl(entityId, acl);
            if (result.isDefined()) {
                return Rest.responseWithMessage(Response.Status.BAD_REQUEST, result.get());
            }
        }
        if (delta.containsKey("favorite")) {
            Object rawValue = delta.get("favorite");
            boolean favorite = rawValue instanceof Boolean ? Boolean.valueOf((Boolean)rawValue) : Boolean.valueOf(rawValue.toString());
            if (favorite) {
                this.favorites.favoriteTraceConfiguration(entity.getID(), user);
            } else {
                this.favorites.unfavoriteTraceConfiguration(entity.getID(), user);
            }
        }
        this.traceConfigurationMRU.updateOrInsert(entity.getID(), user);
        return this.traceConfigurationAsJSONResponse(entity, TraceConfigurationResource.responseKeys(delta.keySet(), keys));
    }

    @Path(value="{id}")
    @DELETE
    @Consumes(value={"*/*"})
    @Operation(summary="Delete a trace configuration", description="If the supplied ID does refer to a trace configuration, that configuration will be deleted. This API call does not indicate whether or not a configuration was deleted.The end result is that the supplied ID is no longer associated with a trace configuration. ", operationId="deleteTraceConfiguration")
    public Response deleteTraceConfiguration(@Parameter(description="Trace configuration ID", required=true, schema=@Schema(type="string", format="integer")) @PathParam(value="id") String entityId) {
        Option<Response> accessDeniedResponse;
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        Either<Response, Integer> idOrResponse = Primitives.asTOrResponse(RestResponseAdapter.INSTANCE, Primitives.asIntegerOrMessage(TRACE_ID_ERROR_MESSAGE_NAME, entityId, this.f.i18nResolverAdapterOption));
        if (idOrResponse.isLeft()) {
            return idOrResponse.getLeft();
        }
        int id = idOrResponse.get();
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        boolean administratorOverride = user != null && Jira.hasJiraAdministratorsPermission(this.f.globalPermissionManager, user);
        Option<TraceConfigurationAccessControl.TraceConfigurationAccess> effectiveAccess = this.traceConfigurationAccessControl.effectiveAccess(id, user);
        if (!administratorOverride && (accessDeniedResponse = this.renderVTE33ResponseIfInsufficientAccess(effectiveAccess, TraceConfigurationAccessControl.TraceConfigurationAccess.OWNER, entityId)).isDefined()) {
            return accessDeniedResponse.get();
        }
        this.traceConfigurations.deleteTraceConfiguration(id);
        return Rest.responseWithNoContent();
    }

    public static <R> Either<R, TraceConfigurationAO> produceTraceConfigurationAOOrVTE20(ResponseAdapter<R> responseAdapter, String entityId, TraceConfigurations traceConfigurations, Factory f) {
        Either<R, Integer> idOrResponse = Primitives.asTOrResponse(responseAdapter, Primitives.asIntegerOrMessage(TRACE_ID_ERROR_MESSAGE_NAME, entityId, f.i18nResolverAdapterOption));
        if (idOrResponse.isLeft()) {
            return Either.left(idOrResponse.getLeft());
        }
        int id = idOrResponse.get();
        Option<TraceConfigurationAO> entityOption = traceConfigurations.getTraceConfiguration(id, f.jiraAuthenticationContext.getLoggedInUser());
        if (entityOption.isEmpty()) {
            return Either.left(responseAdapter.responseWithMessage(Response.Status.NOT_FOUND, VTE20UnknownObject.message(f.i18nResolverAdapterOption, "vivid.trace.phrase.trace-id", Integer.toString(id))));
        }
        return Either.right(entityOption.get());
    }

    private Option<Response> renderVTE33ResponseIfInsufficientAccess(Option<TraceConfigurationAccessControl.TraceConfigurationAccess> effectiveAccess, TraceConfigurationAccessControl.TraceConfigurationAccess requiredAccess, String traceConfigurationId) {
        boolean sufficientAccess = effectiveAccess.isDefined() && requiredAccess.satisfies(effectiveAccess);
        return sufficientAccess ? Option.none() : Option.of(Rest.responseWithMessage(Response.Status.FORBIDDEN, VTE33AccessDenied.message(this.f.i18nResolverAdapterOption, "vivid.trace.phrase.trace", traceConfigurationId)));
    }

    @Path(value="mru")
    @GET
    @Operation(summary="Gets Most Recently Used (MRU) trace configuration info for the current user (authentication context).", description="Response data is structured as a list of maps, each indicating the name and ID of a trace configuration. The list is ordered, most-recent first.", operationId="getTraceConfigurationMRUS")
    @ApiResponse(responseCode="200", description="MRU trace configuration info")
    public Response getTraceConfigurationMRUS() {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        List<MRUAO> entities = this.traceConfigurationMRU.getMRUs(user);
        ArrayList<Map> mrus = new ArrayList<Map>();
        for (MRUAO mru : entities) {
            Option<TraceConfigurationAO> traceConfiguration = this.traceConfigurations.getTraceConfiguration(Integer.parseInt(mru.getObjectId()), user);
            if (traceConfiguration.isEmpty()) continue;
            mrus.add(io.vavr.collection.HashMap.of("id", mru.getObjectId(), "name", traceConfiguration.get().getName()).toJavaMap());
        }
        return Rest.responseWithJSONEntity(Response.Status.OK, mrus);
    }

    @Path(value="mru")
    @DELETE
    @Operation(summary="Delete Most Recently Used (MRU) trace configuration info for the current user (authentication context).", operationId="clearTraceConfigurationMRUS")
    @ApiResponse(responseCode="204", description="Trace configuration MRU info has been idempotently deleted.")
    public Response clearTraceConfigurationMRUS() {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        this.traceConfigurationMRU.deleteAllForUser(user.getKey());
        return Rest.responseWithNoContent();
    }

    @Schema(description="Trace configuration")
    public static class TraceConfiguration {
        List<ACE> acl;
        boolean favorite;
        String name;

        public List<ACE> getAcl() {
            return this.acl;
        }

        public boolean getFavorite() {
            return this.favorite;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ACE {
        ProjectResource.ACPrincipalEnum type;
        String id;
        TraceConfigurationAccessControl.TraceConfigurationAccess aspect;

        public ProjectResource.ACPrincipalEnum getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public TraceConfigurationAccessControl.TraceConfigurationAccess getAspect() {
            return this.aspect;
        }
    }
}

