/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.rest;

import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.VTE26AuthenticationRequired;
import vivid.lib.rest.Rest;
import vivid.trace.components.Factory;
import vivid.trace.components.UserPreferences;
import vivid.trace.jira.servlets.ValidateXsrfToken;

@Path(value="user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="user", description="User preferences")
public class UserResource {
    private final Factory f;
    @Context
    private HttpServletRequest httpServletRequest;
    private final UserPreferences userPreferences;

    @Inject
    public UserResource(Factory factory, UserPreferences userPreferences) {
        this.f = factory;
        this.userPreferences = userPreferences;
    }

    @GET
    @Operation(summary="Gets the preferences stored for the currently authenticated user.", description="This call is therefore applicable only to authenticated users and not anonymous users.", operationId="getUserPreferences")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Preferences for the authenticated user."), @ApiResponse(responseCode="401", description="Applicable only for authenticated users.")})
    public Response respondWithUserPreferences() {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        if (!this.f.jiraAuthenticationContext.isLoggedInUser()) {
            return Rest.responseWithMessage(Response.Status.UNAUTHORIZED, VTE26AuthenticationRequired.message(this.f.i18nResolverAdapterOption));
        }
        return this.responseWithUserPreferences();
    }

    private Response responseWithUserPreferences() {
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        Map<String, String> preferences = this.userPreferences.getUserPreferences(user);
        return Rest.responseWithJSONEntity(Response.Status.OK, preferences);
    }

    @PUT
    @Operation(summary="Sets the preferences for the currently authenticated user.", description="This call is therefore applicable only to authenticated users and not anonymous users.", operationId="setUserPreferences")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Preferences were stored successfully."), @ApiResponse(responseCode="401", description="Applicable only for authenticated users.")})
    public Response setUserPreferences(@RequestBody(description="Changed portions of the user's preferences", content={@Content(schema=@Schema(implementation=UserPreferencesSchema.class))}) String delta) throws IOException {
        Option<Response> invalidXsrfTokenResponse = ValidateXsrfToken.validateXsrfToken(this.httpServletRequest, this.f);
        if (invalidXsrfTokenResponse.isDefined()) {
            return invalidXsrfTokenResponse.get();
        }
        if (!this.f.jiraAuthenticationContext.isLoggedInUser()) {
            return Rest.responseWithMessage(Response.Status.UNAUTHORIZED, VTE26AuthenticationRequired.message(this.f.i18nResolverAdapterOption));
        }
        Map<String, String> newState = Jackson.readValue(delta, new Jackson.TypeReference<Map<String, String>>(this){});
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        this.userPreferences.setUserPreferences(user, newState);
        return this.responseWithUserPreferences();
    }

    @Schema(description="User's preferences")
    public static class UserPreferencesSchema {
        @Schema(name="distance")
        String distance;
        @Schema(name="showRelationshipLabels")
        String showRelationshipLabels;
        @Schema(name="viewport-mode")
        String viewportMode;

        public String getDistance() {
            return this.distance;
        }

        public String getShowRelationshipLabels() {
            return this.showRelationshipLabels;
        }

        public String getViewportMode() {
            return this.viewportMode;
        }
    }
}

