/**
 * @license
 * Copyright 2022 Vivid Inc. and/or its affiliates.
 */

"use strict";

if (typeof VT == 'undefined') {
    var VT = {};
}
if (typeof VT.Trace == 'undefined') {
    VT.Trace = {};
}
if (typeof VT.Trace.Standalone == 'undefined') {
    VT.Trace.Standalone = {};
}

// FIXME: Clicking a saved trace for the first time causes the browser to reload the page, while in edit mode.

VT.Trace.Standalone.createIssueRelationGraphModel = function(data) {
    return new VT.Components.IssueRelationGraphModel(
        _.extend(
            {},
            JSON.parse(data.defaultTraceConfiguration).configuration,
            data,
            data.traceConfiguration,
            {
                // TODO Does this do quick nav? JIRA.trigger(JIRA.Events.REFRESH_ISSUE_PAGE, [JIRA.Issue.getIssueId()]);
                issueNavigationClickHandler: function(issueKey) {
                    var baseUrl = AJS.$("meta[name='ajs-base-url']").attr("content");
                    window.open(
                        baseUrl + "/browse/" + issueKey,
                        "_blank"
                    );
                },
                issues: data.issues || {},
                relations: data.relations || [],
                sortKeyForIssuesFn: VT.Trace.sortKeyForIssues
            }
        )
    );
};

VT.Trace.Standalone.createIssueRelationGraphView = function(data, issueRelationGraphModel) {
    return new VT.Components.IssueRelationGraphView({
        el: data.mountPointEl,
        initialize: function() {
            VT.Components.IssueRelationGraphView.prototype.initialize.apply(this, arguments);
        },
        model: issueRelationGraphModel,
        fetchGraphDataDelegate: function(requestContext) {
            var artifactTypes = this.model.get('artifactTypes');
            var directions = this.model.get('directions');
            var distance = parseInt(this.model.get('distance'));
            var includeSeedIssues = this.model.get('includeSeedIssues');
            var itemCardLayout = this.model.get('itemCardLayout');
            var issueLinkTypes = this.model.get('issueLinkTypes');
            var relationsSeedIssuesArg = this.model.getRelationsSeedIssuesArg();

            // Requests are generated by user-driven events in time sequence, so this new request context
            // represents the most recent request; any older request context can be safely clobbered.
            this.model.set('requestContext', requestContext);

            var _this = this;

            var proxyData = {};
            if (typeof data.applicationLinkId != 'undefined') {
                proxyData["vt-proxy-app-link-id"] = data.applicationLinkId;
                proxyData["vt-proxy-path"] = '/rest/vivid-trace/1/graph/relations';
            }

            var ajaxData = Object.assign(
                {
                    directions: directions,
                    distance: !isNaN(distance) ? distance : undefined,
                    includeSeedIssues: includeSeedIssues,
                    itemCardLayout: itemCardLayout,
                    relationsSeedIssuesArg: relationsSeedIssuesArg
                },
                proxyData
            );
            if ('artifactTypes' in proxyData) {
                ajaxData['artifactTypes'] = artifactTypes;
            }
            if ('issueLinkTypes' in proxyData) {
                ajaxData['issueLinkTypes'] = issueLinkTypes;
            }

            AJS.$.ajax({
                url: data.proxyUrl || AJS.contextPath() + '/rest/vivid-trace/1/graph/relations',
                data: ajaxData,
                success: function(data) {
                    if (VT.Components.isCurrentRequestContext(_this.model, requestContext)) {
                        _this.model.unset('requestContext');

                        _this.model.set(data);
                        VT.Fn.trigger(VT.Components.REDRAW_IRG_EVENT);
                    }
                },
                error: function(xhr) {
                    VT.Fn.showRestErrorMessage(
                        xhr
                    );

                    // Restore the IRG as it was to remove the appearance of a request being in-flight.
                    VT.Fn.trigger(VT.Components.REDRAW_IRG_EVENT);
                }
            });
        },
        viewportDimensions: function() {
            // Consume the width of the page.
            var bcr = document.body.getBoundingClientRect();
            return {
                viewportWidth: window.innerWidth - bcr.left
            };
        }
    });
};

VT.Trace.Standalone.render = function(data) {

    // Massage the provided data.
    if (_.isString(data.traceConfiguration)) {
        data.traceConfiguration = JSON.parse(data.traceConfiguration);
    }
    data.initialTraceConfiguration = data.traceConfiguration;

    // Instantiate components.
    var issueRelationGraphModel = VT.Trace.Standalone.createIssueRelationGraphModel(data);
    var issueRelationGraphView = VT.Trace.Standalone.createIssueRelationGraphView(
        data,
        issueRelationGraphModel
    );

    // Initiate rendering.
    if (!VT.Fn.hasErrorMessages(data.messages)) {
        issueRelationGraphView.fetchGraphData();
    }

};
