/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.WriteHandler;
import com.cognitect.transit.Writer;
import com.cognitect.transit.impl.Cache;
import com.cognitect.transit.impl.JsonEmitter;
import com.cognitect.transit.impl.JsonVerboseEmitter;
import com.cognitect.transit.impl.MsgpackEmitter;
import com.cognitect.transit.impl.WriteCache;
import com.cognitect.transit.impl.WriteHandlerMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Function;
import vivid.shaded.com.fasterxml.jackson.core.JsonFactory;
import vivid.shaded.com.fasterxml.jackson.core.JsonGenerator;
import vivid.shaded.org.msgpack.MessagePack;
import vivid.shaded.org.msgpack.packer.Packer;

public class WriterFactory {
    private static final Map<Map<Class, WriteHandler<?, ?>>, WriteHandlerMap> handlerCache = new Cache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WriteHandlerMap buildWriteHandlerMap(Map<Class, WriteHandler<?, ?>> customHandlers) {
        WriteHandlerMap writeHandlerMap;
        if (customHandlers instanceof WriteHandlerMap) {
            return new WriteHandlerMap(customHandlers);
        }
        Map<Map<Class, WriteHandler<?, ?>>, WriteHandlerMap> map = handlerCache;
        synchronized (map) {
            writeHandlerMap = handlerCache.get(customHandlers);
            if (writeHandlerMap == null) {
                writeHandlerMap = new WriteHandlerMap(customHandlers);
                handlerCache.put(customHandlers, writeHandlerMap);
            }
        }
        return new WriteHandlerMap(writeHandlerMap);
    }

    private static WriteHandlerMap verboseHandlerMap(Map<Class, WriteHandler<?, ?>> customHandlers) {
        return WriterFactory.buildWriteHandlerMap(customHandlers).verboseWriteHandlerMap();
    }

    public static <T> Writer<T> getJsonInstance(OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers, WriteHandler<?, ?> defaultWriteHandler, boolean verboseMode) throws IOException {
        return WriterFactory.getJsonInstance(out, customHandlers, defaultWriteHandler, verboseMode, null);
    }

    public static <T> Writer<T> getJsonInstance(final OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers, WriteHandler<?, ?> defaultWriteHandler, boolean verboseMode, Function<Object, Object> transform) throws IOException {
        JsonGenerator gen = new JsonFactory().createGenerator(out);
        final JsonEmitter emitter = verboseMode ? new JsonVerboseEmitter(gen, WriterFactory.verboseHandlerMap(customHandlers), defaultWriteHandler, transform) : new JsonEmitter(gen, WriterFactory.buildWriteHandlerMap(customHandlers), defaultWriteHandler, transform);
        final WriteCache writeCache = new WriteCache(!verboseMode);
        return new Writer<T>(){

            @Override
            public void write(T o) {
                try {
                    emitter.emit(o, false, writeCache.init());
                    out.flush();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static <T> Writer<T> getMsgpackInstance(OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers, WriteHandler<?, ?> defaultWriteHandler) throws IOException {
        return WriterFactory.getMsgpackInstance(out, customHandlers, defaultWriteHandler, null);
    }

    public static <T> Writer<T> getMsgpackInstance(final OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers, WriteHandler<?, ?> defaultWriteHandler, Function<Object, Object> transform) throws IOException {
        Packer packer = new MessagePack().createPacker(out);
        final MsgpackEmitter emitter = new MsgpackEmitter(packer, WriterFactory.buildWriteHandlerMap(customHandlers), defaultWriteHandler, transform);
        final WriteCache writeCache = new WriteCache(true);
        return new Writer<T>(){

            @Override
            public void write(T o) {
                try {
                    emitter.emit(o, false, writeCache.init());
                    out.flush();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static WriteHandler defaultDefaultHandler() {
        return new WriteHandler(){

            private String throwException(Object o) {
                throw new RuntimeException("Not supported " + o);
            }

            public String tag(Object o) {
                return this.throwException(o);
            }

            public Object rep(Object o) {
                return this.throwException(o);
            }

            public String stringRep(Object o) {
                return this.throwException(o);
            }

            public WriteHandler getVerboseHandler() {
                return null;
            }
        };
    }

    @Deprecated
    public static <T> Writer<T> getMsgpackInstance(OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers) throws IOException {
        return WriterFactory.getMsgpackInstance(out, customHandlers, null);
    }

    @Deprecated
    public static <T> Writer<T> getJsonInstance(OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers, boolean verboseMode) throws IOException {
        return WriterFactory.getJsonInstance(out, customHandlers, null, verboseMode);
    }
}

