/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Lazy;
import io.vavr.PartialFunction;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.Value;
import io.vavr.collection.Collections;
import io.vavr.collection.GwtIncompatible;
import io.vavr.collection.Iterator;
import io.vavr.collection.JavaConverters;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Queue;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public abstract class Stream<T>
implements LinearSeq<T> {
    private static final long serialVersionUID = 1L;

    private Stream() {
    }

    public static <T> Collector<T, ArrayList<T>, Stream<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, Stream> finisher = Stream::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Iterable<? extends T> ... iterables) {
        return Iterator.concat(iterables).toStream();
    }

    public static <T> Stream<T> concat(Iterable<? extends Iterable<? extends T>> iterables) {
        return Iterator.concat(iterables).toStream();
    }

    public static Stream<Integer> from(int value) {
        return Stream.ofAll(Iterator.from(value));
    }

    public static Stream<Integer> from(int value, int step) {
        return Stream.ofAll(Iterator.from(value, step));
    }

    public static Stream<Long> from(long value) {
        return Stream.ofAll(Iterator.from(value));
    }

    public static Stream<Long> from(long value, long step) {
        return Stream.ofAll(Iterator.from(value, step));
    }

    public static <T> Stream<T> continually(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return Stream.ofAll(Iterator.continually(supplier));
    }

    public static <T> Stream<T> iterate(T seed, Function<? super T, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Stream.ofAll(Iterator.iterate(seed, f));
    }

    public static <T> Stream<T> iterate(Supplier<? extends Option<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return Stream.ofAll(Iterator.iterate(supplier));
    }

    public static <T> Stream<T> cons(T head, Supplier<? extends Stream<? extends T>> tailSupplier) {
        Objects.requireNonNull(tailSupplier, "tailSupplier is null");
        return new ConsImpl<T>(head, tailSupplier);
    }

    public static <T> Stream<T> empty() {
        return Empty.instance();
    }

    public static <T> Stream<T> narrow(Stream<? extends T> stream) {
        return stream;
    }

    public static <T> Stream<T> of(T element) {
        return Stream.cons(element, Empty::instance);
    }

    @SafeVarargs
    public static <T> Stream<T> of(final T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < elements.length;
            }

            @Override
            public T next() {
                return elements[this.i++];
            }
        });
    }

    public static <T> Stream<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Stream.ofAll(Collections.tabulate(n, f));
    }

    public static <T> Stream<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Stream.ofAll(Collections.fill(n, s));
    }

    public static <T> Stream<T> fill(int n, T element) {
        return Stream.ofAll(Collections.fillObject(n, element));
    }

    public static <T> Stream<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof Stream) {
            return (Stream)elements;
        }
        return StreamFactory.create(elements.iterator());
    }

    public static <T> Stream<T> ofAll(java.util.stream.Stream<? extends T> javaStream) {
        Objects.requireNonNull(javaStream, "javaStream is null");
        return StreamFactory.create(javaStream.iterator());
    }

    public static Stream<Boolean> ofAll(boolean ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(Iterator.ofAll(elements));
    }

    public static Stream<Byte> ofAll(byte ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(Iterator.ofAll(elements));
    }

    public static Stream<Character> ofAll(char ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(Iterator.ofAll(elements));
    }

    public static Stream<Double> ofAll(double ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(Iterator.ofAll(elements));
    }

    public static Stream<Float> ofAll(float ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(Iterator.ofAll(elements));
    }

    public static Stream<Integer> ofAll(int ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(Iterator.ofAll(elements));
    }

    public static Stream<Long> ofAll(long ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(Iterator.ofAll(elements));
    }

    public static Stream<Short> ofAll(short ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Stream.ofAll(Iterator.ofAll(elements));
    }

    public static Stream<Character> range(char from, char toExclusive) {
        return Stream.ofAll(Iterator.range(from, toExclusive));
    }

    public static Stream<Character> rangeBy(char from, char toExclusive, int step) {
        return Stream.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    @GwtIncompatible
    public static Stream<Double> rangeBy(double from, double toExclusive, double step) {
        return Stream.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static Stream<Integer> range(int from, int toExclusive) {
        return Stream.ofAll(Iterator.range(from, toExclusive));
    }

    public static Stream<Integer> rangeBy(int from, int toExclusive, int step) {
        return Stream.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static Stream<Long> range(long from, long toExclusive) {
        return Stream.ofAll(Iterator.range(from, toExclusive));
    }

    public static Stream<Long> rangeBy(long from, long toExclusive, long step) {
        return Stream.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static Stream<Character> rangeClosed(char from, char toInclusive) {
        return Stream.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static Stream<Character> rangeClosedBy(char from, char toInclusive, int step) {
        return Stream.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    @GwtIncompatible
    public static Stream<Double> rangeClosedBy(double from, double toInclusive, double step) {
        return Stream.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static Stream<Integer> rangeClosed(int from, int toInclusive) {
        return Stream.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static Stream<Integer> rangeClosedBy(int from, int toInclusive, int step) {
        return Stream.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static Stream<Long> rangeClosed(long from, long toInclusive) {
        return Stream.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static Stream<Long> rangeClosedBy(long from, long toInclusive, long step) {
        return Stream.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static <T> Stream<Stream<T>> transpose(Stream<Stream<T>> matrix) {
        return Collections.transpose(matrix, Stream::ofAll, Stream::of);
    }

    public static <T, U> Stream<U> unfoldRight(T seed, Function<? super T, Option<Tuple2<? extends U, ? extends T>>> f) {
        return Iterator.unfoldRight(seed, f).toStream();
    }

    public static <T, U> Stream<U> unfoldLeft(T seed, Function<? super T, Option<Tuple2<? extends T, ? extends U>>> f) {
        return Iterator.unfoldLeft(seed, f).toStream();
    }

    public static <T> Stream<T> unfold(T seed, Function<? super T, Option<Tuple2<? extends T, ? extends T>>> f) {
        return Iterator.unfold(seed, f).toStream();
    }

    public static <T> Stream<T> continually(T t) {
        return Stream.ofAll(Iterator.continually(t));
    }

    @Override
    public abstract Stream<T> append(T var1);

    @Override
    public abstract Stream<T> appendAll(Iterable<? extends T> var1);

    public final Stream<T> appendSelf(Function<? super Stream<T>, ? extends Stream<T>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? this : new AppendSelf(this, mapper).stream();
    }

    @Override
    @GwtIncompatible
    public final java.util.List<T> asJava() {
        return JavaConverters.asJava(this, JavaConverters.ChangePolicy.IMMUTABLE);
    }

    @Override
    @GwtIncompatible
    public final Stream<T> asJava(Consumer<? super java.util.List<T>> action) {
        return Collections.asJava(this, action, JavaConverters.ChangePolicy.IMMUTABLE);
    }

    @Override
    @GwtIncompatible
    public final java.util.List<T> asJavaMutable() {
        return JavaConverters.asJava(this, JavaConverters.ChangePolicy.MUTABLE);
    }

    @Override
    @GwtIncompatible
    public final Stream<T> asJavaMutable(Consumer<? super java.util.List<T>> action) {
        return Collections.asJava(this, action, JavaConverters.ChangePolicy.MUTABLE);
    }

    @Override
    public final <R> Stream<R> collect(PartialFunction<? super T, ? extends R> partialFunction) {
        return Stream.ofAll(this.iterator().collect(partialFunction));
    }

    @Override
    public final Stream<Stream<T>> combinations() {
        return ((Stream)Stream.rangeClosed(0, this.length()).map((T n) -> this.combinations((int)n))).flatMap(Function.identity());
    }

    @Override
    public final Stream<Stream<T>> combinations(int k) {
        return Combinations.apply(this, Math.max(k, 0));
    }

    @Override
    public final Iterator<Stream<T>> crossProduct(int power) {
        return Collections.crossProduct(Stream.empty(), this, power);
    }

    public final Stream<T> cycle() {
        return this.isEmpty() ? this : this.appendSelf(Function.identity());
    }

    public final Stream<T> cycle(final int count) {
        if (count <= 0 || this.isEmpty()) {
            return Stream.empty();
        }
        final Stream self = this;
        return Stream.ofAll(new Iterator<T>(){
            Stream<T> stream;
            int i;
            {
                this.stream = self;
                this.i = count - 1;
            }

            @Override
            public boolean hasNext() {
                return !this.stream.isEmpty() || this.i > 0;
            }

            @Override
            public T next() {
                if (this.stream.isEmpty()) {
                    --this.i;
                    this.stream = self;
                }
                Object result = this.stream.head();
                this.stream = this.stream.tail();
                return result;
            }
        });
    }

    @Override
    public final Stream<T> distinct() {
        return this.distinctBy(Function.identity());
    }

    @Override
    public final Stream<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        TreeSet<? super T> seen = new TreeSet<T>(comparator);
        return this.filter(seen::add);
    }

    @Override
    public final <U> Stream<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        HashSet seen = new HashSet();
        return this.filter((T t) -> seen.add(keyExtractor.apply(t)));
    }

    @Override
    public final Stream<T> drop(int n) {
        LinearSeq<T> stream = this;
        while (n-- > 0 && !stream.isEmpty()) {
            stream = stream.tail();
        }
        return stream;
    }

    @Override
    public final Stream<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    public final Stream<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LinearSeq<T> stream = this;
        while (!stream.isEmpty() && predicate.test(stream.head())) {
            stream = stream.tail();
        }
        return stream;
    }

    @Override
    public final Stream<T> dropRight(int n) {
        if (n <= 0) {
            return this;
        }
        return DropRight.apply(this.take(n).toList(), List.empty(), this.drop(n));
    }

    @Override
    public final Stream<T> dropRightUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return ((Stream)((Stream)this.reverse()).dropUntil((Predicate)predicate)).reverse();
    }

    @Override
    public final Stream<T> dropRightWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropRightUntil((Predicate)predicate.negate());
    }

    @Override
    public final Stream<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return this;
        }
        LinearSeq<T> stream = this;
        while (!stream.isEmpty() && !predicate.test(stream.head())) {
            stream = stream.tail();
        }
        Stream finalStream = stream;
        return stream.isEmpty() ? Stream.empty() : Stream.cons(stream.head(), () -> ((Stream)finalStream.tail()).filter(predicate));
    }

    @Override
    public final Stream<T> filterNot(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Collections.filterNot(this, predicate);
    }

    @Override
    @Deprecated
    public final Stream<T> reject(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Collections.reject(this, predicate);
    }

    @Override
    public final <U> Stream<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? Empty.instance() : Stream.ofAll(new FlatMapIterator(this.iterator(), mapper));
    }

    @Override
    public final T get(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index + ") on Nil");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("get(" + index + ")");
        }
        LinearSeq<T> stream = this;
        for (int i = index - 1; i >= 0; --i) {
            if (!(stream = ((Stream)stream).tail()).isEmpty()) continue;
            throw new IndexOutOfBoundsException("get(" + index + ") on Stream of size " + (index - i));
        }
        return stream.head();
    }

    @Override
    public final <C> Map<C, Stream<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return Collections.groupBy(this, classifier, Stream::ofAll);
    }

    @Override
    public final Iterator<Stream<T>> grouped(int size) {
        return this.sliding(size, size);
    }

    @Override
    public final boolean hasDefiniteSize() {
        return false;
    }

    @Override
    public final int indexOf(T element, int from) {
        int index = 0;
        LinearSeq<T> stream = this;
        while (!stream.isEmpty()) {
            if (index >= from && Objects.equals(stream.head(), element)) {
                return index;
            }
            stream = stream.tail();
            ++index;
        }
        return -1;
    }

    @Override
    public final Stream<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty stream");
        }
        LinearSeq tail = this.tail();
        if (tail.isEmpty()) {
            return Empty.instance();
        }
        return Stream.cons(this.head(), () -> this.init());
    }

    @Override
    public final Option<Stream<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public final Stream<T> insert(int index, T element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e)");
        }
        if (index == 0) {
            return Stream.cons(element, () -> this);
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e) on Nil");
        }
        return Stream.cons(this.head(), () -> ((Stream)this.tail()).insert(index - 1, (Object)element));
    }

    @Override
    public final Stream<T> insertAll(int index, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (index < 0) {
            throw new IndexOutOfBoundsException("insertAll(" + index + ", elements)");
        }
        if (index == 0) {
            return this.isEmpty() ? Stream.ofAll(elements) : Stream.ofAll(elements).appendAll((Iterable)this);
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("insertAll(" + index + ", elements) on Nil");
        }
        return Stream.cons(this.head(), () -> ((Stream)this.tail()).insertAll(index - 1, (Iterable)elements));
    }

    @Override
    public final Stream<T> intersperse(T element) {
        if (this.isEmpty()) {
            return this;
        }
        return Stream.cons(this.head(), () -> {
            Stream<Object> tail = this.tail();
            return tail.isEmpty() ? tail : Stream.cons(element, () -> tail.intersperse(element));
        });
    }

    @Override
    public final boolean isAsync() {
        return false;
    }

    @Override
    public final boolean isLazy() {
        return true;
    }

    @Override
    public final boolean isTraversableAgain() {
        return true;
    }

    @Override
    public final T last() {
        return Collections.last(this);
    }

    @Override
    public final int lastIndexOf(T element, int end) {
        int result = -1;
        LinearSeq<T> stream = this;
        for (int index = 0; index <= end && !stream.isEmpty(); ++index) {
            if (Objects.equals(stream.head(), element)) {
                result = index;
            }
            stream = stream.tail();
        }
        return result;
    }

    @Override
    public final int length() {
        return this.foldLeft(0, (n, ignored) -> n + 1);
    }

    @Override
    public final <U> Stream<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return Empty.instance();
        }
        return Stream.cons(mapper.apply(this.head()), () -> ((Stream)this.tail()).map(mapper));
    }

    @Override
    public final Stream<T> padTo(int length, T element) {
        if (length <= 0) {
            return this;
        }
        if (this.isEmpty()) {
            return Stream.continually(element).take(length);
        }
        return Stream.cons(this.head(), () -> ((Stream)this.tail()).padTo(length - 1, (Object)element));
    }

    @Override
    public final Stream<T> leftPadTo(int length, T element) {
        int actualLength = this.length();
        if (length <= actualLength) {
            return this;
        }
        return ((Stream)Stream.continually(element).take(length - actualLength)).appendAll((Iterable)this);
    }

    @Override
    public final Stream<T> orElse(Iterable<? extends T> other) {
        return this.isEmpty() ? Stream.ofAll(other) : this;
    }

    @Override
    public final Stream<T> orElse(Supplier<? extends Iterable<? extends T>> supplier) {
        return this.isEmpty() ? Stream.ofAll(supplier.get()) : this;
    }

    @Override
    public final Stream<T> patch(int from, Iterable<? extends T> that, int replaced) {
        from = from < 0 ? 0 : from;
        replaced = replaced < 0 ? 0 : replaced;
        LinearSeq result = ((Stream)this.take(from)).appendAll((Iterable)that);
        result = ((Stream)result).appendAll((Iterable)this.drop(from += replaced));
        return result;
    }

    @Override
    public final Tuple2<Stream<T>, Stream<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Tuple.of(this.filter(predicate), this.filter((Predicate)predicate.negate()));
    }

    @Override
    public final Stream<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        action.accept(head);
        return Stream.cons(head, () -> ((Stream)this.tail()).peek(action));
    }

    @Override
    public final Stream<Stream<T>> permutations() {
        if (this.isEmpty()) {
            return Empty.instance();
        }
        LinearSeq tail = this.tail();
        if (tail.isEmpty()) {
            return Stream.of(this);
        }
        Empty zero = Empty.instance();
        return this.distinct().foldLeft(zero, (xs, x) -> {
            Function<Stream, Stream> prepend = l -> l.prepend(x);
            return xs.appendAll((Iterable)((Stream)((Stream)this.remove(x)).permutations()).map(prepend));
        });
    }

    @Override
    public final Stream<T> prepend(T element) {
        return Stream.cons(element, () -> this);
    }

    @Override
    public final Stream<T> prependAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty()) {
            if (elements instanceof Stream) {
                Stream stream = (Stream)elements;
                return stream;
            }
            return Stream.ofAll(elements);
        }
        return Stream.ofAll(elements).appendAll((Iterable)this);
    }

    @Override
    public final Stream<T> remove(T element) {
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        return Objects.equals(head, element) ? this.tail() : Stream.cons(head, () -> ((Stream)this.tail()).remove((Object)element));
    }

    @Override
    public final Stream<T> removeFirst(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        return predicate.test(head) ? this.tail() : Stream.cons(head, () -> ((Stream)this.tail()).removeFirst(predicate));
    }

    @Override
    public final Stream<T> removeLast(Predicate<T> predicate) {
        return this.isEmpty() ? this : ((Stream)((Stream)this.reverse()).removeFirst((Predicate)predicate)).reverse();
    }

    @Override
    public final Stream<T> removeAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("removeAt(" + index + ")");
        }
        if (index == 0) {
            return this.tail();
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("removeAt() on Nil");
        }
        return Stream.cons(this.head(), () -> ((Stream)this.tail()).removeAt(index - 1));
    }

    @Override
    public final Stream<T> removeAll(T element) {
        return Collections.removeAll(this, element);
    }

    @Override
    public final Stream<T> removeAll(Iterable<? extends T> elements) {
        return Collections.removeAll(this, elements);
    }

    @Override
    @Deprecated
    public final Stream<T> removeAll(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.reject((Predicate)predicate);
    }

    @Override
    public final Stream<T> replace(T currentElement, T newElement) {
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        if (Objects.equals(head, currentElement)) {
            return Stream.cons(newElement, () -> this.tail());
        }
        return Stream.cons(head, () -> ((Stream)this.tail()).replace((Object)currentElement, (Object)newElement));
    }

    @Override
    public final Stream<T> replaceAll(T currentElement, T newElement) {
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        T newHead = Objects.equals(head, currentElement) ? newElement : head;
        return Stream.cons(newHead, () -> ((Stream)this.tail()).replaceAll((Object)currentElement, (Object)newElement));
    }

    @Override
    public final Stream<T> retainAll(Iterable<? extends T> elements) {
        return Collections.retainAll(this, elements);
    }

    /*
     * Exception decompiling
     */
    @Override
    public final Stream<T> reverse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.TernaryExpression.applyExpressionRewriter(TernaryExpression.java:106)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final Stream<T> rotateLeft(int n) {
        return Collections.rotateLeft(this, n);
    }

    @Override
    public final Stream<T> rotateRight(int n) {
        return Collections.rotateRight(this, n);
    }

    @Override
    public final Stream<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    @Override
    public final <U> Stream<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        return Collections.scanLeft(this, zero, operation, Value::toStream);
    }

    @Override
    public final <U> Stream<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        return Collections.scanRight(this, zero, operation, Value::toStream);
    }

    @Override
    public final Stream<T> shuffle() {
        return Collections.shuffle(this, Stream::ofAll);
    }

    @Override
    public final Stream<T> shuffle(Random random) {
        return Collections.shuffle(this, random, Stream::ofAll);
    }

    @Override
    public final Stream<T> slice(int beginIndex, int endIndex) {
        if (beginIndex >= endIndex || this.isEmpty()) {
            return Stream.empty();
        }
        int lowerBound = Math.max(beginIndex, 0);
        if (lowerBound == 0) {
            return Stream.cons(this.head(), () -> ((Stream)this.tail()).slice(0, endIndex - 1));
        }
        return ((Stream)this.tail()).slice(lowerBound - 1, endIndex - 1);
    }

    @Override
    public final Iterator<Stream<T>> slideBy(Function<? super T, ?> classifier) {
        return this.iterator().slideBy(classifier).map(Stream::ofAll);
    }

    @Override
    public final Iterator<Stream<T>> sliding(int size) {
        return this.sliding(size, 1);
    }

    @Override
    public final Iterator<Stream<T>> sliding(int size, int step) {
        return this.iterator().sliding(size, step).map(Stream::ofAll);
    }

    @Override
    public final Stream<T> sorted() {
        return this.isEmpty() ? this : this.toJavaStream().sorted().collect(Stream.collector());
    }

    @Override
    public final Stream<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.isEmpty() ? this : this.toJavaStream().sorted(comparator).collect(Stream.collector());
    }

    @Override
    public final <U extends Comparable<? super U>> Stream<T> sortBy(Function<? super T, ? extends U> mapper) {
        return this.sortBy(Comparable::compareTo, (Function)mapper);
    }

    @Override
    public final <U> Stream<T> sortBy(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        return Collections.sortBy(this, comparator, mapper, Stream.collector());
    }

    @Override
    public final Tuple2<Stream<T>, Stream<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Tuple.of(this.takeWhile((Predicate)predicate), this.dropWhile((Predicate)predicate));
    }

    @Override
    public final Tuple2<Stream<T>, Stream<T>> splitAt(int n) {
        return Tuple.of(this.take(n), this.drop(n));
    }

    @Override
    public final Tuple2<Stream<T>, Stream<T>> splitAt(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Tuple.of(this.takeWhile((Predicate)predicate.negate()), this.dropWhile((Predicate)predicate.negate()));
    }

    @Override
    public final Tuple2<Stream<T>, Stream<T>> splitAtInclusive(Predicate<? super T> predicate) {
        Tuple2<Stream<T>, Stream<T>> split = this.splitAt(predicate);
        if (((Stream)split._2).isEmpty()) {
            return split;
        }
        return Tuple.of(((Stream)split._1).append(((Stream)split._2).head()), ((Stream)split._2).tail());
    }

    @Override
    public final String stringPrefix() {
        return "Stream";
    }

    @Override
    public final Stream<T> subSequence(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ")");
        }
        LinearSeq<T> result = this;
        int i = 0;
        while (i < beginIndex) {
            if (result.isEmpty()) {
                throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ") on Stream of size " + i);
            }
            ++i;
            result = result.tail();
        }
        return result;
    }

    @Override
    public final Stream<T> subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ", " + endIndex + ")");
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("subSequence(" + beginIndex + ", " + endIndex + ")");
        }
        if (beginIndex == endIndex) {
            return Empty.instance();
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("subSequence of Nil");
        }
        if (beginIndex == 0) {
            return Stream.cons(this.head(), () -> ((Stream)this.tail()).subSequence(0, endIndex - 1));
        }
        return ((Stream)this.tail()).subSequence(beginIndex - 1, endIndex - 1);
    }

    @Override
    public abstract Stream<T> tail();

    @Override
    public final Option<Stream<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public final Stream<T> take(int n) {
        if (n < 1 || this.isEmpty()) {
            return Stream.empty();
        }
        if (n == 1) {
            return Stream.cons(this.head(), Stream::empty);
        }
        return Stream.cons(this.head(), () -> ((Stream)this.tail()).take(n - 1));
    }

    @Override
    public final Stream<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeWhile((Predicate)predicate.negate());
    }

    @Override
    public final Stream<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Empty.instance();
        }
        Object head = this.head();
        if (predicate.test(head)) {
            return Stream.cons(head, () -> ((Stream)this.tail()).takeWhile(predicate));
        }
        return Empty.instance();
    }

    @Override
    public final Stream<T> takeRight(int n) {
        LinearSeq<T> right = this;
        LinearSeq remaining = this.drop(n);
        while (!remaining.isEmpty()) {
            right = right.tail();
            remaining = ((Stream)remaining).tail();
        }
        return right;
    }

    @Override
    public final Stream<T> takeRightUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return ((Stream)((Stream)this.reverse()).takeUntil((Predicate)predicate)).reverse();
    }

    @Override
    public final Stream<T> takeRightWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeRightUntil((Predicate)predicate.negate());
    }

    public final <U> U transform(Function<? super Stream<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public final <T1, T2> Tuple2<Stream<T1>, Stream<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        LinearSeq stream = this.map(unzipper);
        LinearSeq stream1 = ((Stream)stream).map((T t) -> t._1);
        LinearSeq stream2 = ((Stream)stream).map((T t) -> t._2);
        return Tuple.of(stream1, stream2);
    }

    @Override
    public final <T1, T2, T3> Tuple3<Stream<T1>, Stream<T2>, Stream<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        LinearSeq stream = this.map(unzipper);
        LinearSeq stream1 = ((Stream)stream).map((T t) -> t._1);
        LinearSeq stream2 = ((Stream)stream).map((T t) -> t._2);
        LinearSeq stream3 = ((Stream)stream).map((T t) -> t._3);
        return Tuple.of(stream1, stream2, stream3);
    }

    @Override
    public final Stream<T> update(int index, T element) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("update(" + index + ", e) on Nil");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("update(" + index + ", e)");
        }
        LinearSeq preceding = Empty.instance();
        LinearSeq<T> tail = this;
        int i = index;
        while (i > 0) {
            if (tail.isEmpty()) {
                throw new IndexOutOfBoundsException("update at " + index);
            }
            preceding = ((Stream)preceding).prepend(tail.head());
            --i;
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            throw new IndexOutOfBoundsException("update at " + index);
        }
        return ((Stream)((Stream)preceding).reverse()).appendAll((Iterable)((Stream)tail.tail()).prepend((Object)element));
    }

    @Override
    public final Stream<T> update(int index, Function<? super T, ? extends T> updater) {
        Objects.requireNonNull(updater, "updater is null");
        return this.update(index, (Object)updater.apply(this.get(index)));
    }

    @Override
    public final <U> Stream<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        return this.zipWith((Iterable)that, Tuple::of);
    }

    @Override
    public final <U, R> Stream<R> zipWith(Iterable<? extends U> that, BiFunction<? super T, ? super U, ? extends R> mapper) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return Stream.ofAll(this.iterator().zipWith(that, mapper));
    }

    @Override
    public final <U> Stream<Tuple2<T, U>> zipAll(Iterable<? extends U> iterable, T thisElem, U thatElem) {
        Objects.requireNonNull(iterable, "iterable is null");
        return Stream.ofAll(this.iterator().zipAll(iterable, thisElem, thatElem));
    }

    @Override
    public final Stream<Tuple2<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(Tuple::of);
    }

    @Override
    public final <U> Stream<U> zipWithIndex(BiFunction<? super T, ? super Integer, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return Stream.ofAll(this.iterator().zipWithIndex(mapper));
    }

    public final Stream<T> extend(T next) {
        return Stream.ofAll(this.appendAll(Stream.continually(next)));
    }

    public final Stream<T> extend(Supplier<? extends T> nextSupplier) {
        Objects.requireNonNull(nextSupplier, "nextSupplier is null");
        return Stream.ofAll(this.appendAll(Stream.continually(nextSupplier)));
    }

    public final Stream<T> extend(final Function<? super T, ? extends T> nextFunction) {
        Objects.requireNonNull(nextFunction, "nextFunction is null");
        if (this.isEmpty()) {
            return this;
        }
        final Stream that = this;
        return Stream.ofAll(new Iterator<T>(){
            Stream<T> stream;
            T last;
            {
                this.stream = that;
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.stream.isEmpty()) {
                    this.stream = Stream.iterate(nextFunction.apply(this.last), nextFunction);
                }
                this.last = this.stream.head();
                this.stream = this.stream.tail();
                return this.last;
            }
        });
    }

    private static final class FlatMapIterator<T, U>
    implements Iterator<U> {
        final Function<? super T, ? extends Iterable<? extends U>> mapper;
        final Iterator<? extends T> inputs;
        java.util.Iterator<? extends U> current = java.util.Collections.emptyIterator();

        FlatMapIterator(Iterator<? extends T> inputs, Function<? super T, ? extends Iterable<? extends U>> mapper) {
            this.inputs = inputs;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            boolean currentHasNext;
            while (!(currentHasNext = this.current.hasNext()) && this.inputs.hasNext()) {
                this.current = this.mapper.apply(this.inputs.next()).iterator();
            }
            return currentHasNext;
        }

        @Override
        public U next() {
            return this.current.next();
        }
    }

    private static final class StreamIterator<T>
    implements Iterator<T> {
        private Supplier<Stream<T>> current = () -> stream;

        StreamIterator(Cons<T> stream) {
        }

        @Override
        public boolean hasNext() {
            return !this.current.get().isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Stream<T> stream = this.current.get();
            this.current = stream::tail;
            return stream.head();
        }
    }

    private static interface StreamFactory {
        public static <T> Stream<T> create(java.util.Iterator<? extends T> iterator) {
            return iterator.hasNext() ? Stream.cons(iterator.next(), () -> StreamFactory.create(iterator)) : Empty.instance();
        }
    }

    private static interface DropRight {
        public static <T> Stream<T> apply(List<T> front, List<T> rear, Stream<T> remaining) {
            if (remaining.isEmpty()) {
                return remaining;
            }
            if (front.isEmpty()) {
                return DropRight.apply(rear.reverse(), List.empty(), remaining);
            }
            return Stream.cons(front.head(), () -> DropRight.apply(front.tail(), rear.prepend(remaining.head()), remaining.tail()));
        }
    }

    private static interface Combinations {
        public static <T> Stream<Stream<T>> apply(Stream<T> elements, int k) {
            if (k == 0) {
                return Stream.of(Stream.empty());
            }
            return ((Stream)elements.zipWithIndex()).flatMap(t -> Combinations.apply(elements.drop((Integer)t._2 + 1), k - 1).map(c -> c.prepend(t._1)));
        }
    }

    private static final class AppendSelf<T> {
        private final Cons<T> self;

        AppendSelf(Cons<T> self, Function<? super Stream<T>, ? extends Stream<T>> mapper) {
            this.self = this.appendAll(self, mapper);
        }

        private Cons<T> appendAll(Cons<T> stream, Function<? super Stream<T>, ? extends Stream<T>> mapper) {
            return (Cons)Stream.cons(stream.head(), () -> {
                LinearSeq tail = stream.tail();
                return tail.isEmpty() ? (Cons<T>)mapper.apply(this.self) : this.appendAll((Cons)tail, mapper);
            });
        }

        Cons<T> stream() {
            return this.self;
        }
    }

    @GwtIncompatible(value="The Java serialization protocol is explicitly not supported")
    private static final class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Cons<T> stream;

        SerializationProxy(Cons<T> stream) {
            this.stream = stream;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.stream.length());
            LinearSeq<T> l = this.stream;
            while (!l.isEmpty()) {
                s.writeObject(l.head());
                l = ((Stream)l).tail();
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            int size = s.readInt();
            if (size <= 0) {
                throw new InvalidObjectException("No elements");
            }
            LinearSeq temp = Empty.instance();
            for (int i = 0; i < size; ++i) {
                Object element = s.readObject();
                temp = ((Stream)temp).append(element);
            }
            this.stream = (Cons)temp;
        }

        private Object readResolve() {
            return this.stream;
        }
    }

    private static final class AppendElements<T>
    extends Cons<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Queue<T> queue;

        AppendElements(T head, Queue<T> queue, Supplier<Stream<T>> tail) {
            super(head, tail);
            this.queue = queue;
        }

        @Override
        public Stream<T> append(T element) {
            return new AppendElements<Object>(this.head, (Queue<Object>)this.queue.append((Object)element), this.tail);
        }

        @Override
        public Stream<T> appendAll(Iterable<? extends T> elements) {
            Objects.requireNonNull(elements, "elements is null");
            return new AppendElements<Object>(this.head, (Queue<Object>)this.queue.appendAll((Iterable)elements), this.tail);
        }

        @Override
        public Stream<T> tail() {
            Stream t = (Stream)this.tail.get();
            if (t.isEmpty()) {
                return Stream.ofAll(this.queue);
            }
            if (t instanceof ConsImpl) {
                ConsImpl c = (ConsImpl)t;
                return new AppendElements(c.head(), this.queue, c.tail);
            }
            AppendElements a = (AppendElements)t;
            return new AppendElements(a.head(), a.queue.appendAll((Iterable)this.queue), a.tail);
        }

        @GwtIncompatible(value="The Java serialization protocol is explicitly not supported")
        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        @GwtIncompatible(value="The Java serialization protocol is explicitly not supported")
        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }
    }

    private static final class ConsImpl<T>
    extends Cons<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ConsImpl(T head, Supplier<Stream<T>> tail) {
            super(head, tail);
        }

        @Override
        public Stream<T> append(T element) {
            return new AppendElements(this.head(), Queue.of(element), () -> this.tail());
        }

        @Override
        public Stream<T> appendAll(Iterable<? extends T> elements) {
            Objects.requireNonNull(elements, "elements is null");
            if (Collections.isEmpty(elements)) {
                return this;
            }
            return Stream.ofAll(Iterator.concat(this, elements));
        }

        @Override
        public Stream<T> tail() {
            return (Stream)this.tail.get();
        }

        @GwtIncompatible(value="The Java serialization protocol is explicitly not supported")
        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        @GwtIncompatible(value="The Java serialization protocol is explicitly not supported")
        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }
    }

    @Deprecated
    public static abstract class Cons<T>
    extends Stream<T> {
        private static final long serialVersionUID = 1L;
        final T head;
        final Lazy<Stream<T>> tail;

        Cons(T head, Supplier<Stream<T>> tail) {
            Objects.requireNonNull(tail, "tail is null");
            this.head = head;
            this.tail = Lazy.of(tail);
        }

        @Override
        public T head() {
            return this.head;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return new StreamIterator(this);
        }

        @Override
        public boolean equals(Object o) {
            return Collections.equals(this, o);
        }

        @Override
        public int hashCode() {
            return Collections.hashOrdered(this);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.stringPrefix()).append("(");
            LinearSeq<T> stream = this;
            while (stream != null && !stream.isEmpty()) {
                Cons cons = stream;
                builder.append(cons.head);
                if (cons.tail.isEvaluated()) {
                    if ((stream = ((Stream)stream).tail()).isEmpty()) continue;
                    builder.append(", ");
                    continue;
                }
                builder.append(", ?");
                stream = null;
            }
            return builder.append(")").toString();
        }
    }

    @Deprecated
    public static final class Empty<T>
    extends Stream<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Empty<?> INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public Stream<T> append(T element) {
            return Stream.of(element);
        }

        @Override
        public Stream<T> appendAll(Iterable<? extends T> elements) {
            Objects.requireNonNull(elements, "elements is null");
            if (Collections.isEmpty(elements)) {
                return this;
            }
            return Stream.ofAll(elements);
        }

        public static <T> Empty<T> instance() {
            return INSTANCE;
        }

        @Override
        public T head() {
            throw new NoSuchElementException("head of empty stream");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterator.empty();
        }

        @Override
        public Stream<T> tail() {
            throw new UnsupportedOperationException("tail of empty stream");
        }

        @Override
        public boolean equals(Object o) {
            return Collections.equals(this, o);
        }

        @Override
        public int hashCode() {
            return Collections.hashOrdered(this);
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

