/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.atlassian;

import com.atlassian.activeobjects.external.ActiveObjects;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.LoggerFactory;

public class ActiveObjectz {
    public static final String VTE_19_DETAIL_KEY_ACTIVE_OBJECTS_ENTITY = "active-objects-entity";
    public static final int PAGED_EXECUTION_MAX_PAGE_SIZE = 1024;

    private ActiveObjectz() {
    }

    public static String buildInStr(Collection<String> values) {
        int size = values.size();
        if (size == 1) {
            return " IN (?)";
        }
        if (size == 2) {
            return " IN (?, ?)";
        }
        if (size == 3) {
            return " IN (?, ?, ?)";
        }
        if (size == 4) {
            return " IN (?, ?, ?, ?)";
        }
        if (size == 5) {
            return " IN (?, ?, ?, ?, ?)";
        }
        if (size == 6) {
            return " IN (?, ?, ?, ?, ?, ?)";
        }
        if (size == 7) {
            return " IN (?, ?, ?, ?, ?, ?, ?)";
        }
        if (size == 8) {
            return " IN (?, ?, ?, ?, ?, ?, ?, ?)";
        }
        if (size == 9) {
            return " IN (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }
        if (size == 10) {
            return " IN (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }
        String qs = values.stream().map(v -> "?").collect(Collectors.joining(", "));
        return " IN (" + qs + ")";
    }

    public static String buildWhereStr(String ... columnNames) {
        StringBuilder where = new StringBuilder();
        boolean first = true;
        for (String c : columnNames) {
            if (!first) {
                where.append(" AND ");
            }
            where.append(c);
            where.append(" = ?");
            first = false;
        }
        return where.toString();
    }

    public static void deleteEntities(ActiveObjects activeObjects, Entity[] entities) {
        activeObjects.executeInTransaction(() -> {
            activeObjects.delete((RawEntity[])entities);
            return null;
        });
    }

    public static <T extends RawEntity<K>, K> void pagedExecution(ActiveObjects activeObjects, Class<T> clazz, Consumer<T> task, Class<?> caller) {
        RawEntity[] page;
        int count = activeObjects.count(clazz);
        long startTime = System.nanoTime();
        for (int offset = 0; offset < count && (page = activeObjects.find(clazz, Query.select().order("ID ASC").offset(offset).limit(1024))) != null && page.length >= 1; offset += page.length) {
            Arrays.stream(page).forEach(task);
        }
        long endTime = System.nanoTime();
        long nanos = endTime - startTime;
        String millis = String.format("%.03f", (double)nanos / 1000000.0);
        LoggerFactory.getLogger(caller).warn("INFO: Paged execution for {} ActiveObjects objects took {} ms", (Object)count, (Object)millis);
    }
}

