/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.atlassian;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vivid.lib.ResponseAdapter;
import vivid.lib.atlassian.Servlets;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageSet;

public class ServletResponseAdapter
implements ResponseAdapter<Void> {
    private static final Logger log = LoggerFactory.getLogger(ServletResponseAdapter.class);
    private final HttpServletResponse response;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ServletResponseAdapter(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    @SuppressFBWarnings(value={"LO_TOSTRING_PARAMETER"})
    public Void responseWithMessage(Response.Status status, Message message) {
        this.response.setStatus(status.getStatusCode());
        try {
            Servlets.renderMessagesToServletResponse(this.response, MessageSet.of(message));
        }
        catch (IOException e) {
            log.error("Encountered an exception while attempting to write message as servlet response: Message = {}. Exception = {}.", (Object)message, (Object)(e.getMessage() + "\n" + Arrays.toString(e.getStackTrace())));
        }
        return null;
    }
}

