/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.messages;

import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.codehaus.jackson.annotate.JsonIgnore;
import vivid.lib.messages.Message;
import vivid.lib.messages.MessageType;

public class MessageSet
implements Iterable<Message> {
    public final java.util.List<Message> messages = new ArrayList<Message>();

    public static MessageSet of(Message message) {
        MessageSet ms = new MessageSet();
        ms.add(message);
        return ms;
    }

    public void add(Message message) {
        this.messages.add(message);
    }

    public void addAll(MessageSet anotherMessages) {
        for (Message message : anotherMessages) {
            this.messages.add(message);
        }
    }

    public static void addMessageTo(Option<MessageSet> messageSetOption, Message message) {
        if (messageSetOption.isDefined()) {
            messageSetOption.get().add(message);
        }
    }

    public Map<String, String> asMap() {
        return Stream.ofAll(this.messages).foldLeft(HashMap.empty(), (map, message) -> map.put(message.getCodeOption().get(), message.getMessage())).toJavaMap();
    }

    public java.util.List<Map<String, String>> asCollection() {
        return Stream.ofAll(this.messages).foldLeft(List.empty(), (list, message) -> list.append(message.getDetails())).toJavaList();
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    public String joinMessagesOfTypes(String on, MessageType types) {
        return String.join((CharSequence)on, ((Stream)Stream.ofAll(this.messages).filter((Predicate)new MessageTypePredicate(types))).map(Message::getMessage));
    }

    public boolean hasMessagesOfTypes(MessageType ... types) {
        return this.messages.stream().anyMatch(new MessageTypePredicate(types));
    }

    private static class MessageTypePredicate
    implements Predicate<Message> {
        private final EnumSet<MessageType> soughtTypes = EnumSet.noneOf(MessageType.class);

        MessageTypePredicate(MessageType ... types) {
            this.soughtTypes.addAll(Arrays.asList(types));
        }

        @Override
        public boolean test(Message input) {
            MessageType type = input.getType();
            return this.soughtTypes.contains((Object)type);
        }
    }
}

