/*
 * Decompiled with CFR 0.152.
 */
package vivid.lib.messages;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import vivid.lib.I18n;
import vivid.lib.messages.CodedMessage;
import vivid.lib.messages.Message;

public class VTE19InternalError
extends CodedMessage {
    private static final String I18N_KEY = "vivid.trace.error.vte-19-internal-error";
    private static final VTE19InternalError M = new VTE19InternalError();

    private VTE19InternalError() {
    }

    public static Message message(Option<I18n.ResolverAdapter> i18nResolverAdapterOption, String details) {
        return new Message.MessageBuilder(M.getMessageType(), I18n.getText(i18nResolverAdapterOption, I18N_KEY, new Serializable[0])).code(M.getMessageCode()).addDetail("supplementary-message", details).build();
    }

    public static Message message(Option<I18n.ResolverAdapter> i18nResolverAdapterOption, String details, Throwable t) {
        return VTE19InternalError.builder(i18nResolverAdapterOption, details, t).build();
    }

    public static Message.MessageBuilder builder(Option<I18n.ResolverAdapter> i18nResolverAdapterOption, String details, Throwable t) {
        return new Message.MessageBuilder(M.getMessageType(), I18n.getText(i18nResolverAdapterOption, I18N_KEY, new Serializable[0])).code(M.getMessageCode()).addDetail("stack-trace", VTE19InternalError.stackTraceAsString(t)).addDetail("supplementary-message", details);
    }

    public static Message hardcodedMessage(Throwable t) {
        return new Message.MessageBuilder(M.getMessageType(), "VTE-19: An internal error occurred. For support, please report the following information to Vivid Support.").code(M.getMessageCode()).addDetail("stack-trace", VTE19InternalError.stackTraceAsString(t)).build();
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"})
    private static String stackTraceAsString(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter((Writer)sw, true);){
            pw.append(t.getMessage());
            pw.append("\n");
            t.printStackTrace(pw);
        }
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.getBuffer().toString();
    }
}

