/*
 * Decompiled with CFR 0.152.
 */
package vivid.license;

import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;
import vivid.lib.I18n;
import vivid.lib.compatibility.Jackson;
import vivid.lib.messages.Message;
import vivid.lib.messages.VTE19InternalError;
import vivid.lib.messages.VTE21LicenseFormat;
import vivid.license.Licensing;

public class LicenseV1 {
    private static final String LICENSE_DATA_STRUCTURE_VERSION = "1";
    private static final String VSEN_KEY = "vsen";
    private static final String ORGANIZATION_KEY = "organization";
    private static final String ISSUER_KEY = "issuer";
    private static final String ISSUE_DATE_KEY = "issue-date";
    private static final String MAINTENANCE_EXPIRY_DATE_KEY = "maintenance-expiry-date";
    private static final String LICENSE_TYPE_KEY = "license-type";
    private static final String DIGITAL_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String ASYMMETRIC_ALGORITHM = "RSA";
    private static final String RSA_PUBLIC_KEY = "MIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAxlTbGCvFhudirLfTmBZAMcrw0CZz28q3PrkuUw8Ol+tWRbGu/WUw/z9LfkuT1kbM+h9eHGpHyytJcBbVp7bCjOKF+JXtDo7y5Ienck6Fma3CLEPpPh7idCLyPW0WujvE/m+JZCf3CVb0B+YmEWiG0OUtTMVvkbL56nMxcngj309AoT+t8VU7DC06ksM7DHlrp/xGY1uIKCFLwuP3Xh0wMlB7hrcF4j7GMULwoZRKLmukpu27WMT5cnBQ7YxcEHgLOnbp75EwL/tV4S5hwMSEb2O6iWamK0NxCskpK7e3w6MQ5Va0ULjS9+32OaqV7QxsAgMSS6JxWoRFH9RbBtIbgetUD66fFq3payNOg2bnvsnDew0jV4ZbuoM0fbLZeTDZq2Atayhn2mIAo7JL61Uk9ssbsqlSDJ439xwdRUA/ORZohKfdbKe7JAo0kAU4ha90+55BjkGgBi2x2aN34KHV9xP8YsfUN+vKMwBbKuCaoRamWbFRH02X+fF6/w7o3eWRAgMBAAE=";
    private final Map<String, Object> attributes;

    public LicenseV1(Map<String, Object> attributes) {
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getVsen() {
        return (String)Objects.requireNonNull(this.attributes.get(VSEN_KEY));
    }

    public String getOrganization() {
        return (String)Objects.requireNonNull(this.attributes.get(ORGANIZATION_KEY));
    }

    public String getLicenseType() {
        return (String)Objects.requireNonNull(this.attributes.get(LICENSE_TYPE_KEY));
    }

    public String getIssuer() {
        return (String)Objects.requireNonNull(this.attributes.get(ISSUER_KEY));
    }

    public DateTime getIssueDate() {
        return new DateTime(this.attributes.get(ISSUE_DATE_KEY), Licensing.TIME_ZONE);
    }

    public DateTime getMaintenanceExpiryDate() {
        return new DateTime(this.attributes.get(MAINTENANCE_EXPIRY_DATE_KEY), Licensing.TIME_ZONE);
    }

    public static Either<Message, LicenseV1> fromRawLicenseKey(String rawLicenseKey, Option<I18n.ResolverAdapter> i18nResolverAdapterOption) {
        Either<String, byte[]> blob = Licensing.fromBase64(rawLicenseKey);
        if (blob.isLeft()) {
            return Either.left(VTE21LicenseFormat.message(i18nResolverAdapterOption, blob.getLeft()));
        }
        Option<Integer> indexOfNull = Licensing.indexOf(blob.get(), (byte)0);
        if (indexOfNull.isEmpty()) {
            return Either.left(VTE21LicenseFormat.message(i18nResolverAdapterOption, "Technical info: Missing separator."));
        }
        byte[] licenseJsonUtf8Bytes = Arrays.copyOfRange(blob.get(), 0, (int)indexOfNull.get());
        byte[] signatureBytes = Arrays.copyOfRange(blob.get(), indexOfNull.get() + 1, blob.get().length);
        try {
            Signature signature = Signature.getInstance(DIGITAL_SIGNATURE_ALGORITHM);
            byte[] byteKey = Base64.getDecoder().decode(RSA_PUBLIC_KEY.getBytes(StandardCharsets.UTF_8));
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byteKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ASYMMETRIC_ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            signature.initVerify(publicKey);
            signature.update(licenseJsonUtf8Bytes);
            boolean isSignatureValid = signature.verify(signatureBytes);
            if (!isSignatureValid) {
                return Either.left(VTE21LicenseFormat.message(i18nResolverAdapterOption, "Technical info: Invalid signature."));
            }
        }
        catch (GeneralSecurityException e) {
            return Either.left(VTE19InternalError.message(i18nResolverAdapterOption, "Could not use Java security validation capabilities.", e));
        }
        try {
            String licenseJson = new String(licenseJsonUtf8Bytes, StandardCharsets.UTF_8);
            Map<String, Object> license = Jackson.readValue(licenseJson, new Jackson.TypeReference<Map<String, Object>>(){});
            return Either.right(new LicenseV1(license));
        }
        catch (IOException e) {
            return Either.left(VTE19InternalError.message(i18nResolverAdapterOption, "Could not read license key.", e));
        }
    }
}

