/*
 * Decompiled with CFR 0.152.
 */
package vivid.license;

import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.Base64;
import org.joda.time.DateTimeZone;

public class Licensing {
    public static final DateTimeZone TIME_ZONE = DateTimeZone.UTC;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final int LICENSE_LINE_LENGTH = 60;

    private Licensing() {
    }

    static Option<Integer> indexOf(byte[] xs, byte x) {
        if (xs == null) {
            return Option.none();
        }
        for (int i = 0; i < xs.length; ++i) {
            if (xs[i] != x) continue;
            return Option.of(i);
        }
        return Option.none();
    }

    static Either<String, byte[]> fromBase64(String encoded) {
        try {
            return Either.right(Base64.getMimeDecoder().decode(encoded.replaceAll("\\s", "")));
        }
        catch (IllegalArgumentException e) {
            return Either.left("Technical info: Decode error.");
        }
    }

    public static String reformatRawLicenseKey(String rawLicenseKey) {
        return rawLicenseKey.replaceAll("\\s", "").replaceAll("(.{60})", "$1\n");
    }
}

