/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.io.IOException;
import java.nio.ByteBuffer;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class ByteBufferTemplate
extends AbstractTemplate<ByteBuffer> {
    static final ByteBufferTemplate instance = new ByteBufferTemplate();

    private ByteBufferTemplate() {
    }

    @Override
    public void write(Packer pk, ByteBuffer target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write(target);
    }

    @Override
    public ByteBuffer read(Unpacker u, ByteBuffer to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return u.readByteBuffer();
    }

    public static ByteBufferTemplate getInstance() {
        return instance;
    }
}

