/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.io.IOException;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class FloatArrayTemplate
extends AbstractTemplate<float[]> {
    static final FloatArrayTemplate instance = new FloatArrayTemplate();

    private FloatArrayTemplate() {
    }

    @Override
    public void write(Packer pk, float[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (float a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public float[] read(Unpacker u, float[] to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to == null || to.length != n) {
            to = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            to[i] = u.readFloat();
        }
        u.readArrayEnd();
        return to;
    }

    public static FloatArrayTemplate getInstance() {
        return instance;
    }
}

