/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.io.IOException;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class ShortArrayTemplate
extends AbstractTemplate<short[]> {
    static final ShortArrayTemplate instance = new ShortArrayTemplate();

    private ShortArrayTemplate() {
    }

    @Override
    public void write(Packer pk, short[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (short a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public short[] read(Unpacker u, short[] to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to == null || to.length != n) {
            to = new short[n];
        }
        for (int i = 0; i < n; ++i) {
            to[i] = u.readShort();
        }
        u.readArrayEnd();
        return to;
    }

    public static ShortArrayTemplate getInstance() {
        return instance;
    }
}

