/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template;

import java.io.IOException;
import java.lang.reflect.Type;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.template.Template;
import vivid.shaded.org.msgpack.template.TemplateRegistry;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class TemplateReference<T>
extends AbstractTemplate<T> {
    private TemplateRegistry registry;
    private Type targetType;
    private Template<T> actualTemplate;

    public TemplateReference(TemplateRegistry registry, Type targetType) {
        this.registry = registry;
        this.targetType = targetType;
    }

    private void validateActualTemplate() {
        if (this.actualTemplate == null) {
            this.actualTemplate = this.registry.cache.get(this.targetType);
            if (this.actualTemplate == null) {
                throw new MessageTypeException("Actual template have not been created");
            }
        }
    }

    @Override
    public void write(Packer pk, T v, boolean required) throws IOException {
        this.validateActualTemplate();
        this.actualTemplate.write(pk, v, required);
    }

    @Override
    public void write(Packer pk, T v) throws IOException {
        this.validateActualTemplate();
        this.actualTemplate.write(pk, v, false);
    }

    @Override
    public T read(Unpacker u, T to, boolean required) throws IOException {
        this.validateActualTemplate();
        return this.actualTemplate.read(u, to, required);
    }

    @Override
    public T read(Unpacker u, T to) throws IOException {
        this.validateActualTemplate();
        return this.actualTemplate.read(u, to, false);
    }
}

