/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.template.builder;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.packer.Packer;
import vivid.shaded.org.msgpack.template.AbstractTemplate;
import vivid.shaded.org.msgpack.template.Template;
import vivid.shaded.org.msgpack.template.TemplateRegistry;
import vivid.shaded.org.msgpack.template.builder.AbstractTemplateBuilder;
import vivid.shaded.org.msgpack.template.builder.DefaultFieldEntry;
import vivid.shaded.org.msgpack.template.builder.FieldEntry;
import vivid.shaded.org.msgpack.template.builder.ReflectionBeansTemplateBuilder;
import vivid.shaded.org.msgpack.unpacker.Unpacker;

public class ReflectionTemplateBuilder
extends AbstractTemplateBuilder {
    private static Logger LOG = Logger.getLogger(ReflectionBeansTemplateBuilder.class.getName());

    public ReflectionTemplateBuilder(TemplateRegistry registry) {
        this(registry, null);
    }

    public ReflectionTemplateBuilder(TemplateRegistry registry, ClassLoader cl) {
        super(registry);
    }

    @Override
    public boolean matchType(Type targetType, boolean hasAnnotation) {
        Class targetClass = (Class)targetType;
        boolean matched = ReflectionTemplateBuilder.matchAtClassTemplateBuilder(targetClass, hasAnnotation);
        if (matched && LOG.isLoggable(Level.FINE)) {
            LOG.fine("matched type: " + targetClass.getName());
        }
        return matched;
    }

    @Override
    public <T> Template<T> buildTemplate(Class<T> targetClass, FieldEntry[] entries) {
        if (entries == null) {
            throw new NullPointerException("entries is null: " + targetClass);
        }
        ReflectionFieldTemplate[] tmpls = this.toTemplates(entries);
        return new ReflectionClassTemplate<T>(targetClass, tmpls);
    }

    protected ReflectionFieldTemplate[] toTemplates(FieldEntry[] entries) {
        for (FieldEntry entry : entries) {
            Field field = ((DefaultFieldEntry)entry).getField();
            int mod = field.getModifiers();
            if (Modifier.isPublic(mod)) continue;
            field.setAccessible(true);
        }
        ReflectionFieldTemplate[] templates = new ReflectionFieldTemplate[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            FieldEntry entry = entries[i];
            Template template = this.registry.lookup(entry.getGenericType());
            templates[i] = new FieldTemplateImpl(entry, template);
        }
        return templates;
    }

    protected static class ReflectionClassTemplate<T>
    extends AbstractTemplate<T> {
        protected Class<T> targetClass;
        protected ReflectionFieldTemplate[] templates;

        protected ReflectionClassTemplate(Class<T> targetClass, ReflectionFieldTemplate[] templates) {
            this.targetClass = targetClass;
            this.templates = templates;
        }

        @Override
        public void write(Packer packer, T target, boolean required) throws IOException {
            if (target == null) {
                if (required) {
                    throw new MessageTypeException("attempted to write null");
                }
                packer.writeNil();
                return;
            }
            try {
                packer.writeArrayBegin(this.templates.length);
                for (ReflectionFieldTemplate tmpl : this.templates) {
                    if (!tmpl.entry.isAvailable()) {
                        packer.writeNil();
                        continue;
                    }
                    Object obj = tmpl.entry.get(target);
                    if (obj == null) {
                        if (tmpl.entry.isNotNullable()) {
                            throw new MessageTypeException(tmpl.entry.getName() + " cannot be null by @NotNullable");
                        }
                        packer.writeNil();
                        continue;
                    }
                    tmpl.write(packer, obj, true);
                }
                packer.writeArrayEnd();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTypeException(e);
            }
        }

        @Override
        public T read(Unpacker unpacker, T to, boolean required) throws IOException {
            if (!required && unpacker.trySkipNil()) {
                return null;
            }
            try {
                if (to == null) {
                    to = this.targetClass.newInstance();
                }
                unpacker.readArrayBegin();
                for (int i = 0; i < this.templates.length; ++i) {
                    ReflectionFieldTemplate tmpl = this.templates[i];
                    if (!tmpl.entry.isAvailable()) {
                        unpacker.skip();
                        continue;
                    }
                    if (tmpl.entry.isOptional() && unpacker.trySkipNil()) continue;
                    tmpl.read(unpacker, to, false);
                }
                unpacker.readArrayEnd();
                return to;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTypeException(e);
            }
        }
    }

    static final class FieldTemplateImpl
    extends ReflectionFieldTemplate {
        private Template template;

        public FieldTemplateImpl(FieldEntry entry, Template template) {
            super(entry);
            this.template = template;
        }

        @Override
        public void write(Packer packer, Object v, boolean required) throws IOException {
            this.template.write(packer, v, required);
        }

        @Override
        public Object read(Unpacker unpacker, Object to, boolean required) throws IOException {
            Object f = this.entry.get(to);
            Object o = this.template.read(unpacker, f, required);
            if (o != f) {
                this.entry.set(to, o);
            }
            return o;
        }
    }

    protected static abstract class ReflectionFieldTemplate
    extends AbstractTemplate<Object> {
        protected FieldEntry entry;

        ReflectionFieldTemplate(FieldEntry entry) {
            this.entry = entry;
        }

        void setNil(Object v) {
            this.entry.set(v, null);
        }
    }
}

