/*
 * Decompiled with CFR 0.152.
 */
package vivid.shaded.org.msgpack.unpacker;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import vivid.shaded.org.msgpack.MessagePack;
import vivid.shaded.org.msgpack.MessageTypeException;
import vivid.shaded.org.msgpack.io.BufferReferer;
import vivid.shaded.org.msgpack.io.Input;
import vivid.shaded.org.msgpack.io.StreamInput;
import vivid.shaded.org.msgpack.packer.Unconverter;
import vivid.shaded.org.msgpack.type.ValueType;
import vivid.shaded.org.msgpack.unpacker.AbstractUnpacker;
import vivid.shaded.org.msgpack.unpacker.Accept;
import vivid.shaded.org.msgpack.unpacker.ArrayAccept;
import vivid.shaded.org.msgpack.unpacker.BigIntegerAccept;
import vivid.shaded.org.msgpack.unpacker.ByteArrayAccept;
import vivid.shaded.org.msgpack.unpacker.DoubleAccept;
import vivid.shaded.org.msgpack.unpacker.IntAccept;
import vivid.shaded.org.msgpack.unpacker.LongAccept;
import vivid.shaded.org.msgpack.unpacker.MapAccept;
import vivid.shaded.org.msgpack.unpacker.SizeLimitException;
import vivid.shaded.org.msgpack.unpacker.SkipAccept;
import vivid.shaded.org.msgpack.unpacker.StringAccept;
import vivid.shaded.org.msgpack.unpacker.UnpackerStack;
import vivid.shaded.org.msgpack.unpacker.ValueAccept;

public class MessagePackUnpacker
extends AbstractUnpacker {
    private static final byte REQUIRE_TO_READ_HEAD = -63;
    protected final Input in;
    private final UnpackerStack stack = new UnpackerStack();
    private byte headByte = (byte)-63;
    private byte[] raw;
    private int rawFilled;
    private final IntAccept intAccept = new IntAccept();
    private final LongAccept longAccept = new LongAccept();
    private final BigIntegerAccept bigIntegerAccept = new BigIntegerAccept();
    private final DoubleAccept doubleAccept = new DoubleAccept();
    private final ByteArrayAccept byteArrayAccept = new ByteArrayAccept();
    private final StringAccept stringAccept = new StringAccept();
    private final ArrayAccept arrayAccept = new ArrayAccept();
    private final MapAccept mapAccept = new MapAccept();
    private final ValueAccept valueAccept = new ValueAccept();
    private final SkipAccept skipAccept = new SkipAccept();

    public MessagePackUnpacker(MessagePack msgpack, InputStream stream) {
        this(msgpack, new StreamInput(stream));
    }

    protected MessagePackUnpacker(MessagePack msgpack, Input in) {
        super(msgpack);
        this.in = in;
    }

    private byte getHeadByte() throws IOException {
        byte b = this.headByte;
        if (b == -63) {
            b = this.headByte = this.in.readByte();
        }
        return b;
    }

    final void readOne(Accept a) throws IOException {
        this.stack.checkCount();
        if (this.readOneWithoutStack(a)) {
            this.stack.reduceCount();
        }
    }

    final boolean readOneWithoutStack(Accept a) throws IOException {
        if (this.raw != null) {
            this.readRawBodyCont();
            a.acceptRaw(this.raw);
            this.raw = null;
            this.headByte = (byte)-63;
            return true;
        }
        byte b = this.getHeadByte();
        if ((b & 0x80) == 0) {
            a.acceptInteger((int)b);
            this.headByte = (byte)-63;
            return true;
        }
        if ((b & 0xE0) == 224) {
            a.acceptInteger((int)b);
            this.headByte = (byte)-63;
            return true;
        }
        if ((b & 0xE0) == 160) {
            int count = b & 0x1F;
            if (count == 0) {
                a.acceptEmptyRaw();
                this.headByte = (byte)-63;
                return true;
            }
            if (!this.tryReferRawBody(a, count)) {
                this.readRawBody(count);
                a.acceptRaw(this.raw);
                this.raw = null;
            }
            this.headByte = (byte)-63;
            return true;
        }
        if ((b & 0xF0) == 144) {
            int count = b & 0xF;
            a.acceptArray(count);
            this.stack.reduceCount();
            this.stack.pushArray(count);
            this.headByte = (byte)-63;
            return false;
        }
        if ((b & 0xF0) == 128) {
            int count = b & 0xF;
            a.acceptMap(count);
            this.stack.reduceCount();
            this.stack.pushMap(count);
            this.headByte = (byte)-63;
            return false;
        }
        return this.readOneWithoutStackLarge(a, b);
    }

    private boolean readOneWithoutStackLarge(Accept a, int b) throws IOException {
        switch (b & 0xFF) {
            case 192: {
                a.acceptNil();
                this.headByte = (byte)-63;
                return true;
            }
            case 194: {
                a.acceptBoolean(false);
                this.headByte = (byte)-63;
                return true;
            }
            case 195: {
                a.acceptBoolean(true);
                this.headByte = (byte)-63;
                return true;
            }
            case 202: {
                a.acceptFloat(this.in.getFloat());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 203: {
                a.acceptDouble(this.in.getDouble());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 204: {
                a.acceptUnsignedInteger(this.in.getByte());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 205: {
                a.acceptUnsignedInteger(this.in.getShort());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 206: {
                a.acceptUnsignedInteger(this.in.getInt());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 207: {
                a.acceptUnsignedInteger(this.in.getLong());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 208: {
                a.acceptInteger(this.in.getByte());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 209: {
                a.acceptInteger(this.in.getShort());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 210: {
                a.acceptInteger(this.in.getInt());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 211: {
                a.acceptInteger(this.in.getLong());
                this.in.advance();
                this.headByte = (byte)-63;
                return true;
            }
            case 196: 
            case 217: {
                int count = this.in.getByte() & 0xFF;
                if (count == 0) {
                    a.acceptEmptyRaw();
                    this.in.advance();
                    this.headByte = (byte)-63;
                    return true;
                }
                if (count >= this.rawSizeLimit) {
                    String reason = String.format("Size of raw (%d) over limit at %d", count, this.rawSizeLimit);
                    throw new SizeLimitException(reason);
                }
                this.in.advance();
                if (!this.tryReferRawBody(a, count)) {
                    this.readRawBody(count);
                    a.acceptRaw(this.raw);
                    this.raw = null;
                }
                this.headByte = (byte)-63;
                return true;
            }
            case 197: 
            case 218: {
                int count = this.in.getShort() & 0xFFFF;
                if (count == 0) {
                    a.acceptEmptyRaw();
                    this.in.advance();
                    this.headByte = (byte)-63;
                    return true;
                }
                if (count >= this.rawSizeLimit) {
                    String reason = String.format("Size of raw (%d) over limit at %d", count, this.rawSizeLimit);
                    throw new SizeLimitException(reason);
                }
                this.in.advance();
                if (!this.tryReferRawBody(a, count)) {
                    this.readRawBody(count);
                    a.acceptRaw(this.raw);
                    this.raw = null;
                }
                this.headByte = (byte)-63;
                return true;
            }
            case 198: 
            case 219: {
                int count = this.in.getInt();
                if (count == 0) {
                    a.acceptEmptyRaw();
                    this.in.advance();
                    this.headByte = (byte)-63;
                    return true;
                }
                if (count < 0 || count >= this.rawSizeLimit) {
                    String reason = String.format("Size of raw (%d) over limit at %d", count, this.rawSizeLimit);
                    throw new SizeLimitException(reason);
                }
                this.in.advance();
                if (!this.tryReferRawBody(a, count)) {
                    this.readRawBody(count);
                    a.acceptRaw(this.raw);
                    this.raw = null;
                }
                this.headByte = (byte)-63;
                return true;
            }
            case 220: {
                int count = this.in.getShort() & 0xFFFF;
                if (count >= this.arraySizeLimit) {
                    String reason = String.format("Size of array (%d) over limit at %d", count, this.arraySizeLimit);
                    throw new SizeLimitException(reason);
                }
                a.acceptArray(count);
                this.stack.reduceCount();
                this.stack.pushArray(count);
                this.in.advance();
                this.headByte = (byte)-63;
                return false;
            }
            case 221: {
                int count = this.in.getInt();
                if (count < 0 || count >= this.arraySizeLimit) {
                    String reason = String.format("Size of array (%d) over limit at %d", count, this.arraySizeLimit);
                    throw new SizeLimitException(reason);
                }
                a.acceptArray(count);
                this.stack.reduceCount();
                this.stack.pushArray(count);
                this.in.advance();
                this.headByte = (byte)-63;
                return false;
            }
            case 222: {
                int count = this.in.getShort() & 0xFFFF;
                if (count >= this.mapSizeLimit) {
                    String reason = String.format("Size of map (%d) over limit at %d", count, this.mapSizeLimit);
                    throw new SizeLimitException(reason);
                }
                a.acceptMap(count);
                this.stack.reduceCount();
                this.stack.pushMap(count);
                this.in.advance();
                this.headByte = (byte)-63;
                return false;
            }
            case 223: {
                int count = this.in.getInt();
                if (count < 0 || count >= this.mapSizeLimit) {
                    String reason = String.format("Size of map (%d) over limit at %d", count, this.mapSizeLimit);
                    throw new SizeLimitException(reason);
                }
                a.acceptMap(count);
                this.stack.reduceCount();
                this.stack.pushMap(count);
                this.in.advance();
                this.headByte = (byte)-63;
                return false;
            }
        }
        this.headByte = (byte)-63;
        throw new IOException("Invalid byte: " + b);
    }

    private boolean tryReferRawBody(BufferReferer referer, int size) throws IOException {
        return this.in.tryRefer(referer, size);
    }

    private void readRawBody(int size) throws IOException {
        this.raw = new byte[size];
        this.rawFilled = 0;
        this.readRawBodyCont();
    }

    private void readRawBodyCont() throws IOException {
        int len = this.in.read(this.raw, this.rawFilled, this.raw.length - this.rawFilled);
        this.rawFilled += len;
        if (this.rawFilled < this.raw.length) {
            throw new EOFException();
        }
    }

    @Override
    protected boolean tryReadNil() throws IOException {
        this.stack.checkCount();
        int b = this.getHeadByte() & 0xFF;
        if (b == 192) {
            this.stack.reduceCount();
            this.headByte = (byte)-63;
            return true;
        }
        return false;
    }

    @Override
    public boolean trySkipNil() throws IOException {
        if (this.stack.getDepth() > 0 && this.stack.getTopCount() <= 0) {
            return true;
        }
        int b = this.getHeadByte() & 0xFF;
        if (b == 192) {
            this.stack.reduceCount();
            this.headByte = (byte)-63;
            return true;
        }
        return false;
    }

    @Override
    public void readNil() throws IOException {
        this.stack.checkCount();
        int b = this.getHeadByte() & 0xFF;
        if (b == 192) {
            this.stack.reduceCount();
            this.headByte = (byte)-63;
            return;
        }
        throw new MessageTypeException("Expected nil but got not nil value");
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.stack.checkCount();
        int b = this.getHeadByte() & 0xFF;
        if (b == 194) {
            this.stack.reduceCount();
            this.headByte = (byte)-63;
            return false;
        }
        if (b == 195) {
            this.stack.reduceCount();
            this.headByte = (byte)-63;
            return true;
        }
        throw new MessageTypeException("Expected Boolean but got not boolean value");
    }

    @Override
    public byte readByte() throws IOException {
        this.stack.checkCount();
        this.readOneWithoutStack(this.intAccept);
        int value = this.intAccept.value;
        if (value < -128 || value > 127) {
            throw new MessageTypeException();
        }
        this.stack.reduceCount();
        return (byte)value;
    }

    @Override
    public short readShort() throws IOException {
        this.stack.checkCount();
        this.readOneWithoutStack(this.intAccept);
        int value = this.intAccept.value;
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new MessageTypeException();
        }
        this.stack.reduceCount();
        return (short)value;
    }

    @Override
    public int readInt() throws IOException {
        this.readOne(this.intAccept);
        return this.intAccept.value;
    }

    @Override
    public long readLong() throws IOException {
        this.readOne(this.longAccept);
        return this.longAccept.value;
    }

    @Override
    public BigInteger readBigInteger() throws IOException {
        this.readOne(this.bigIntegerAccept);
        return this.bigIntegerAccept.value;
    }

    @Override
    public float readFloat() throws IOException {
        this.readOne(this.doubleAccept);
        return (float)this.doubleAccept.value;
    }

    @Override
    public double readDouble() throws IOException {
        this.readOne(this.doubleAccept);
        return this.doubleAccept.value;
    }

    @Override
    public byte[] readByteArray() throws IOException {
        this.readOne(this.byteArrayAccept);
        return this.byteArrayAccept.value;
    }

    @Override
    public String readString() throws IOException {
        this.readOne(this.stringAccept);
        return this.stringAccept.value;
    }

    @Override
    public int readArrayBegin() throws IOException {
        this.readOne(this.arrayAccept);
        return this.arrayAccept.size;
    }

    @Override
    public void readArrayEnd(boolean check) throws IOException {
        if (!this.stack.topIsArray()) {
            throw new MessageTypeException("readArrayEnd() is called but readArrayBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check) {
                throw new MessageTypeException("readArrayEnd(check=true) is called but the array is not end");
            }
            for (int i = 0; i < remain; ++i) {
                this.skip();
            }
        }
        this.stack.pop();
    }

    @Override
    public int readMapBegin() throws IOException {
        this.readOne(this.mapAccept);
        return this.mapAccept.size;
    }

    @Override
    public void readMapEnd(boolean check) throws IOException {
        if (!this.stack.topIsMap()) {
            throw new MessageTypeException("readMapEnd() is called but readMapBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check) {
                throw new MessageTypeException("readMapEnd(check=true) is called but the map is not end");
            }
            for (int i = 0; i < remain; ++i) {
                this.skip();
            }
        }
        this.stack.pop();
    }

    @Override
    protected void readValue(Unconverter uc) throws IOException {
        if (uc.getResult() != null) {
            uc.resetResult();
        }
        this.valueAccept.setUnconverter(uc);
        this.stack.checkCount();
        if (this.readOneWithoutStack(this.valueAccept)) {
            this.stack.reduceCount();
            if (uc.getResult() != null) {
                return;
            }
        }
        while (true) {
            if (this.stack.getTopCount() == 0) {
                if (this.stack.topIsArray()) {
                    uc.writeArrayEnd(true);
                    this.stack.pop();
                } else if (this.stack.topIsMap()) {
                    uc.writeMapEnd(true);
                    this.stack.pop();
                } else {
                    throw new RuntimeException("invalid stack");
                }
                if (uc.getResult() == null) continue;
                return;
            }
            this.readOne(this.valueAccept);
        }
    }

    @Override
    public void skip() throws IOException {
        this.stack.checkCount();
        if (this.readOneWithoutStack(this.skipAccept)) {
            this.stack.reduceCount();
            return;
        }
        int targetDepth = this.stack.getDepth() - 1;
        while (true) {
            if (this.stack.getTopCount() == 0) {
                this.stack.pop();
                if (this.stack.getDepth() > targetDepth) continue;
                return;
            }
            this.readOne(this.skipAccept);
        }
    }

    @Override
    public ValueType getNextType() throws IOException {
        byte b = this.getHeadByte();
        if ((b & 0x80) == 0) {
            return ValueType.INTEGER;
        }
        if ((b & 0xE0) == 224) {
            return ValueType.INTEGER;
        }
        if ((b & 0xE0) == 160) {
            return ValueType.RAW;
        }
        if ((b & 0xF0) == 144) {
            return ValueType.ARRAY;
        }
        if ((b & 0xF0) == 128) {
            return ValueType.MAP;
        }
        switch (b & 0xFF) {
            case 192: {
                return ValueType.NIL;
            }
            case 194: 
            case 195: {
                return ValueType.BOOLEAN;
            }
            case 202: 
            case 203: {
                return ValueType.FLOAT;
            }
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: {
                return ValueType.INTEGER;
            }
            case 196: 
            case 197: 
            case 198: 
            case 217: 
            case 218: 
            case 219: {
                return ValueType.RAW;
            }
            case 220: 
            case 221: {
                return ValueType.ARRAY;
            }
            case 222: 
            case 223: {
                return ValueType.MAP;
            }
        }
        throw new IOException("Invalid byte: " + b);
    }

    public void reset() {
        this.raw = null;
        this.stack.clear();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int getReadByteCount() {
        return this.in.getReadByteCount();
    }

    @Override
    public void resetReadByteCount() {
        this.in.resetReadByteCount();
    }
}

