/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.accesscontrols;

import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.io.Serializable;
import vivid.lib.I18n;
import vivid.trace.accesscontrols.ACPrincipal;
import vivid.trace.components.Factory;

public class SystemACPrincipal
implements ACPrincipal {
    public static final String TYPE_system = "system";
    public static final String ID_everyone = "everyone";
    public static final String ID_owner = "owner";
    static final String ID_signed_in_users = "signed-in-users";
    static final String ID_defined = "defined";
    private static final HashMap<String, String> SECURITY_PRINCIPAL_NAME_I18N_KEYS = HashMap.of("everyone", "vivid.trace.access.principal.everyone", "signed-in-users", "vivid.trace.access.principal.signed-in-users");

    @Override
    public Option<String> nameFor(String id, Option<Factory> factoryOption) {
        if (factoryOption.isEmpty()) {
            return Option.of(id);
        }
        return SECURITY_PRINCIPAL_NAME_I18N_KEYS.get(id.toLowerCase()).map(k -> I18n.getText(((Factory)factoryOption.get()).i18nResolverAdapterOption, k, new Serializable[0]));
    }

    @Override
    public boolean isEqual(String id, ACPrincipal.Context context) {
        return ID_everyone.equalsIgnoreCase(id) || ID_signed_in_users.equalsIgnoreCase(id);
    }

    @Override
    public String getKey() {
        return TYPE_system;
    }
}

