/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.ao.v1_4;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vivid.lib.Strings;
import vivid.lib.atlassian.ActiveObjectz;
import vivid.trace.ao.v2021_1.AddOnSettingAO;
import vivid.trace.ao.v2021_1.ProjectConfigurationAO;

public class V104000_UpgradeTask_00_All
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(V104000_UpgradeTask_00_All.class);
    public static final String ACTIVE_OBJECTS_MODEL_VERSION_104000 = "104000";
    private static final String ADD_ON_CONFIGURATION_SETTINGS_KEY = "ADD_ON_CONFIGURATION";
    private static final String ISSUE_COUNT_SOFT_MAXIMUM_SETTINGS_KEY = "ISSUE_COUNT_SOFT_MAXIMUM";
    private static final String PLUGIN_SETTINGS_LICENSE_SETTINGS_KEY = "license";
    private static final String SETTINGS_FOLLOW_ISSUE_LINK_TYPES_SETTINGS_KEY = "FOLLOW_ISSUE_LINK_TYPE_IDS";
    private final Settings<Map<String, String>> followLinkTypesSettings = new Settings("FOLLOW_ISSUE_LINK_TYPE_IDS");
    private static final String SETTINGS_ISSUE_FIELDS_SETTINGS_KEY = "ISSUE_FIELDS";
    private final Settings<String> issueFieldsSettings = new Settings("ISSUE_FIELDS");
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ProjectManager projectManager;

    public V104000_UpgradeTask_00_All(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport ProjectManager projectManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.projectManager = projectManager;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)ACTIVE_OBJECTS_MODEL_VERSION_104000);
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        this.upgradeAddOnSettings(activeObjects);
        this.upgradeProjectConfigurations(activeObjects);
    }

    private void upgradeAddOnSettings(ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{AddOnSettingAO.class});
        this.upgradeAddOnSetting(activeObjects, this.pluginSettingsFactory.createSettingsForKey(ADD_ON_CONFIGURATION_SETTINGS_KEY), ISSUE_COUNT_SOFT_MAXIMUM_SETTINGS_KEY, "issue-count-soft-maximum", "Issue Count Soft Maximum");
        this.upgradeAddOnSetting(activeObjects, this.pluginSettingsFactory.createSettingsForKey("vivid.trace"), PLUGIN_SETTINGS_LICENSE_SETTINGS_KEY, "vivid-issued-license", "Vivid Issued License");
    }

    private void upgradeAddOnSetting(ActiveObjects activeObjects, PluginSettings pluginSettings, String pluginSettingsKey, String activeObjectsKey, String humanReadableName) {
        boolean isInActiveObjects;
        String value = (String)pluginSettings.get(pluginSettingsKey);
        boolean isInPluginSettings = value != null && value.length() >= 1;
        AddOnSettingAO[] ps = (AddOnSettingAO[])activeObjects.find(AddOnSettingAO.class, Query.select().where(ActiveObjectz.buildWhereStr("K"), new Object[]{activeObjectsKey}));
        boolean bl = isInActiveObjects = ps.length >= 1;
        if (isInPluginSettings && !isInActiveObjects) {
            log.info("Migrating add-on configuration " + humanReadableName + " setting of '" + value + "' from Plugin Settings to Active Objects.");
            Map map = HashMap.of("K", activeObjectsKey, "V", value).toJavaMap();
            activeObjects.create(AddOnSettingAO.class, map);
        }
        if (isInPluginSettings) {
            pluginSettings.remove(pluginSettingsKey);
        }
    }

    private void upgradeProjectConfigurations(ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{ProjectConfigurationAO.class});
        List projects = this.projectManager.getProjectObjects();
        for (Project project : projects) {
            Option<Map<String, String>> followIssueLinkTypeIdsOption = this.getFollowIssueLinkTypeIds(project);
            Option<String> issueFieldsOption = this.getIssueFields(project);
            if (followIssueLinkTypeIdsOption.isDefined() || issueFieldsOption.isDefined()) {
                log.info("Migrating configuration of project '" + project.getKey() + "' from Plugin Settings to Active Objects.");
                this.createProjectConfigurationEnabledIssueLinkTypes(followIssueLinkTypeIdsOption, activeObjects, project);
                this.createProjectConfigurationIssueFields(issueFieldsOption, activeObjects, project);
            }
            this.followLinkTypesSettings.delete(project);
            this.issueFieldsSettings.delete(project);
        }
    }

    private void createProjectConfigurationEnabledIssueLinkTypes(Option<Map<String, String>> followIssueLinkTypeIdsOption, ActiveObjects activeObjects, Project project) {
        if (followIssueLinkTypeIdsOption.isDefined()) {
            ArrayList<String> enabledIds = new ArrayList<String>();
            for (Map.Entry<String, String> entry : followIssueLinkTypeIdsOption.get().entrySet()) {
                if (!"true".equals(entry.getValue())) continue;
                enabledIds.add(entry.getKey());
            }
            this.create(activeObjects, project, "enabled-issue-link-type-ids", Strings.writeToCsvString(enabledIds));
        }
    }

    private void createProjectConfigurationIssueFields(Option<String> issueFieldsOption, ActiveObjects activeObjects, Project project) {
        if (issueFieldsOption.isDefined()) {
            this.create(activeObjects, project, "issue-field-layout-json", issueFieldsOption.get());
        }
    }

    private void create(ActiveObjects activeObjects, Project project, String key, String value) {
        Map map = HashMap.of("P", project.getId(), "K", key, "V", value).toJavaMap();
        activeObjects.create(ProjectConfigurationAO.class, map);
    }

    private Option<Map<String, String>> getFollowIssueLinkTypeIds(Project project) {
        Map<String, String> followIssueLinkTypeIds = this.followLinkTypesSettings.get(project);
        boolean hasConfiguration = followIssueLinkTypeIds != null && followIssueLinkTypeIds.size() >= 1;
        return hasConfiguration ? Option.of(followIssueLinkTypeIds) : Option.none();
    }

    private Option<String> getIssueFields(Project project) {
        String issueFieldsJson = this.issueFieldsSettings.get(project);
        boolean hasConfiguration = issueFieldsJson != null && issueFieldsJson.length() >= 1;
        return hasConfiguration ? Option.of(issueFieldsJson) : Option.none();
    }

    private class Settings<T> {
        private static final String PROJECT_KEY_SETTINGS_PREFIX = "PROJECT_KEY_";
        private final Set<String> PROJECTMANAGER_GETALLPROJECTKEYS_UNSUPPORTED = new HashSet<String>();
        private final String settingsKey;

        private Settings(String settingsKey) {
            this.settingsKey = settingsKey;
        }

        private Set<String> projectManager_getAllProjectKeys(Long projectId) {
            try {
                Method m = V104000_UpgradeTask_00_All.this.projectManager.getClass().getDeclaredMethod("getAllProjectKeys", Long.class);
                return (Set)m.invoke((Object)V104000_UpgradeTask_00_All.this.projectManager, projectId);
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
                return this.PROJECTMANAGER_GETALLPROJECTKEYS_UNSUPPORTED;
            }
        }

        private String determineGlobalKey(Project project, PluginSettings globalSettings) {
            Set<String> allProjectKeys = this.getAllProjectKeysForProjectKey(project.getKey());
            if (allProjectKeys != null) {
                for (String aProjectKey : allProjectKeys) {
                    String globalKey = this.makeGlobalKey(aProjectKey);
                    if (globalSettings.get(globalKey) == null) continue;
                    return globalKey;
                }
            }
            return this.makeGlobalKey(project.getKey());
        }

        private Set<String> getAllProjectKeysForProjectKey(String projectKey) {
            Project project = V104000_UpgradeTask_00_All.this.projectManager.getProjectObjByKey(projectKey);
            if (project != null) {
                Set<String> allKeys = this.projectManager_getAllProjectKeys(project.getId());
                return allKeys == this.PROJECTMANAGER_GETALLPROJECTKEYS_UNSUPPORTED ? Collections.singleton(projectKey) : allKeys;
            }
            for (Project p : V104000_UpgradeTask_00_All.this.projectManager.getProjectObjects()) {
                Set<String> allKeysForProject = this.projectManager_getAllProjectKeys(p.getId());
                if (allKeysForProject == this.PROJECTMANAGER_GETALLPROJECTKEYS_UNSUPPORTED) {
                    return Collections.emptySet();
                }
                if (!allKeysForProject.contains(projectKey)) continue;
                return allKeysForProject;
            }
            return Collections.emptySet();
        }

        private String makeGlobalKey(String projectKey) {
            return "vivid.trace:PROJECT_KEY_" + projectKey + ":" + this.settingsKey;
        }

        T get(Project project) {
            PluginSettings globalSettings = V104000_UpgradeTask_00_All.this.pluginSettingsFactory.createGlobalSettings();
            String globalKey = this.determineGlobalKey(project, globalSettings);
            return (T)globalSettings.get(globalKey);
        }

        void delete(Project project) {
            PluginSettings globalSettings = V104000_UpgradeTask_00_All.this.pluginSettingsFactory.createGlobalSettings();
            String globalKey = this.determineGlobalKey(project, globalSettings);
            globalSettings.remove(globalKey);
        }
    }
}

