/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import vivid.lib.Strings;
import vivid.trace.accesscontrols.TraceVisibilityAccessControl;
import vivid.trace.components.AddOnConfiguration;
import vivid.trace.components.TraceComponents;
import vivid.trace.data.ContextualTraceConfigurationQuickList;
import vivid.trace.datatypes.ObjectKeyValue;

@Named
public class ProjectConfigurations {
    private final ActiveObjects activeObjects;
    private final AddOnConfiguration addOnConfiguration;
    private final ContextualTraceConfigurationQuickList contextualTraceConfigurationQuickList;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueTypeManager issueTypeManager;
    private final TraceVisibilityAccessControl traceVisibilityAccessControl;

    @Inject
    public ProjectConfigurations(@ComponentImport ActiveObjects activeObjects, AddOnConfiguration addOnConfiguration, ContextualTraceConfigurationQuickList contextualTraceConfigurationQuickList, @ComponentImport IssueLinkTypeManager issueLinkTypeManager, @ComponentImport IssueTypeManager issueTypeManager, TraceVisibilityAccessControl traceVisibilityAccessControl) {
        this.activeObjects = activeObjects;
        this.addOnConfiguration = addOnConfiguration;
        this.contextualTraceConfigurationQuickList = contextualTraceConfigurationQuickList;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueTypeManager = issueTypeManager;
        this.traceVisibilityAccessControl = traceVisibilityAccessControl;
    }

    public void delete(Project project, List<String> keys) {
        if (keys == null) {
            return;
        }
        if (keys.contains("trace-visibility")) {
            this.traceVisibilityAccessControl.deleteForProject(project);
        }
        for (String k : keys) {
            ObjectKeyValue.delete(this.activeObjects, ProjectConfigurations.projectCompositeKey(project, k));
        }
    }

    private static ObjectKeyValue.CompositeKey projectCompositeKey(final Project project, final String key) {
        return new ObjectKeyValue.CompositeKey(){

            @Override
            public String getObjectType() {
                return "project";
            }

            @Override
            public String getObjectId() {
                return project.getId().toString();
            }

            @Override
            public String getKey() {
                return key;
            }
        };
    }

    public Set<String> getEnabledArtifactTypeIds(Project project) {
        Option<String> valueOption = ObjectKeyValue.getValue(this.activeObjects, ProjectConfigurations.projectCompositeKey(project, "enabled-artifact-type-ids"));
        return valueOption.isDefined() ? Strings.readFromCsvString(valueOption.get()) : TraceComponents.allArtifactTypeIds(this.issueTypeManager);
    }

    public void setEnabledArtifactTypes(Project project, Collection<String> enabledArtifactTypeIds) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, ProjectConfigurations.projectCompositeKey(project, "enabled-artifact-type-ids"), Strings.writeToCsvString(enabledArtifactTypeIds));
    }

    public Set<String> getEnabledIssueLinkTypeIds(Project project) {
        Option<String> valueOption = ObjectKeyValue.getValue(this.activeObjects, ProjectConfigurations.projectCompositeKey(project, "enabled-issue-link-type-ids"));
        return valueOption.isDefined() ? Strings.readFromCsvString(valueOption.get()) : TraceComponents.allIssueLinkTypeIds(this.issueLinkTypeManager);
    }

    public void setEnabledIssueLinkTypes(Project project, Collection<String> enabledIssueLinkTypeIds) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, ProjectConfigurations.projectCompositeKey(project, "enabled-issue-link-type-ids"), Strings.writeToCsvString(enabledIssueLinkTypeIds));
    }

    public String getItemCardLayout(Project project) {
        Option<String> valueOption = ObjectKeyValue.getValue(this.activeObjects, ProjectConfigurations.projectCompositeKey(project, "issue-field-layout-json"));
        return valueOption.isDefined() ? valueOption.get() : "[{:id \":jira.issue-field.system/issue-type\" :x 0 :y 0 :w 1 :h 1}{:id \":jira.issue-field.system/key\" :x 1 :y 0 :w 4 :h 1}{:id \":jira.issue-field.system/assignee\" :x 5 :y 0 :w 5 :h 1}{:id \":jira.issue-field.system/priority\" :x 0 :y 1 :w 1 :h 1}{:id \":jira.issue-field.system/summary\" :x 1 :y 1 :w 9 :h 2}]";
    }

    public void setItemCardLayout(Project project, String issueFields) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, ProjectConfigurations.projectCompositeKey(project, "issue-field-layout-json"), issueFields);
    }

    public Option<String> getIssueContextTraceDisplayFormat(Project project) {
        return ObjectKeyValue.getValue(this.activeObjects, ProjectConfigurations.projectCompositeKey(project, "issue-context-trace-display-format"));
    }

    public String getComputedIssueContextTraceDisplayFormat(Project project) {
        Option<String> projectValue = this.getIssueContextTraceDisplayFormat(project);
        return projectValue.isDefined() ? projectValue.get() : this.addOnConfiguration.getIssueContextTraceDisplayFormat();
    }

    public void setIssueContextTraceDisplayFormat(Project project, String projectIssueContextDisplayPreference) {
        ObjectKeyValue.updateOrCreate(this.activeObjects, ProjectConfigurations.projectCompositeKey(project, "issue-context-trace-display-format"), projectIssueContextDisplayPreference);
    }

    public Option<String> getRawContextualTraceConfigurationQuickList(Project project) {
        return this.contextualTraceConfigurationQuickList.getProjectRawValue(project);
    }

    public String getComputedContextualTraceConfigurationQuickList(Project project) {
        return this.contextualTraceConfigurationQuickList.getProjectComputedValue(project);
    }

    public void setContextualTraceConfigurationQuickList(Project project, String value) {
        this.contextualTraceConfigurationQuickList.setProjectValue(project, value);
    }

    public void deleteContextualTraceConfigurationQuickList(Project project) {
        this.contextualTraceConfigurationQuickList.deleteProjectValue(project);
    }
}

