/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.datetime.DateTimeFormatUtils;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.text.StringEscapeUtils;
import vivid.lib.I18n;
import vivid.lib.Strings;
import vivid.lib.messages.MessageSet;
import vivid.lib.messages.MessageType;
import vivid.license.LicenseType;
import vivid.trace.components.AddOnPreconditions;
import vivid.trace.components.Factory;
import vivid.trace.components.ProjectConfigurations;
import vivid.trace.components.UserPreferences;
import vivid.trace.data.TraceConfiguration;
import vivid.trace.ifc.IssueFieldCollector;
import vivid.trace.jira.lib.Jira;
import vivid.trace.license.AddOnLicensing;
import vivid.trace.license.License;

@Named
public class TraceComponents {
    public static final String ARTIFACT_TYPE_MAP_KEY = "artifactTypeMap";
    public static final String BLANK_TRACE_CONFIGURATION_KEY = "blankTraceConfiguration";
    public static final String CONTEXT_PATH_KEY = "contextPath";
    public static final String CONTEXTUAL_TRACE_CONFIGURATION_QUICK_LIST_KEY = "contextual-trace-configuration-quick-list";
    public static final String CURRENT_ISSUE_KEY_KEY = "currentIssueKey";
    private static final String CURRENT_PROJECT_ID_KEY = "currentProjectId";
    private static final String CURRENT_PROJECT_KEY_KEY = "currentProjectKey";
    private static final String DATE_PICKER_JAVASCRIPT_FORMAT_KEY = "datePickerJavascriptFormat";
    private static final String DATE_TIME_PICKER_JAVASCRIPT_FORMAT_KEY = "dateTimePickerJavascriptFormat";
    public static final String DEFAULT_TRACE_CONFIGURATION_KEY = "defaultTraceConfiguration";
    private static final String GRAPH_DIRECTION_KEY = "graphDirection";
    public static final String INITIAL_TRACE_CONFIGURATION_KEY = "initialTraceConfiguration";
    public static final String ISSUE_CONTEXT_TRACE_DISPLAY_FORMAT_KEY = "issue-context-trace-display-format";
    public static final String ISSUE_LINK_TYPE_MAP_KEY = "issueLinkTypeMap";
    private static final String ISSUE_PRIORITY_MAP_KEY = "issuePriorityMap";
    private static final String ISSUE_RESOLUTION_MAP_KEY = "issueResolutionMap";
    private static final String ISSUE_STATUS_MAP_KEY = "issueStatusMap";
    private static final String ISSUE_TYPE_MAP_KEY = "issueTypeMap";
    public static final String IS_USER_AUTHENTICATED_KEY = "isUserAuthenticated";
    public static final String IS_USER_JIRA_ADMIN_KEY = "isUserJiraAdmin";
    private static final String IS_USER_PROJECT_ADMIN_KEY = "isUserProjectAdmin";
    private static final String JQL_QUERY_CONTEXT_FRAGMENT_KEY = "jqlQueryContextFragment";
    private static final String LICENSE_BANNER_KEY = "licenseBanner";
    private static final String PROJECT_MAP_KEY = "projectMap";
    private static final String USER_MAP_KEY = "userMap";
    private static final String USER_TIME_ZONE = "userTimeZone";
    private static final String ISSUES_KEY = "issues";
    public static final String MESSAGES_KEY = "messages";
    private static final String RELATIONS_KEY = "relations";
    private final Factory f;
    private final IssueTypeManager issueTypeManager;
    private final PriorityManager priorityManager;
    private final ProjectConfigurations projectConfiguration;
    private final ResolutionManager resolutionManager;
    private final StatusManager statusManager;

    @Inject
    public TraceComponents(Factory factory, @ComponentImport IssueTypeManager issueTypeManager, @ComponentImport PriorityManager priorityManager, ProjectConfigurations projectConfiguration, @ComponentImport ResolutionManager resolutionManager, @ComponentImport StatusManager statusManager) {
        this.f = factory;
        this.issueTypeManager = issueTypeManager;
        this.priorityManager = priorityManager;
        this.projectConfiguration = projectConfiguration;
        this.resolutionManager = resolutionManager;
        this.statusManager = statusManager;
    }

    static Set<String> allArtifactTypeIds(IssueTypeManager issueTypeManager) {
        HashSet<String> artifactTypeIds = new HashSet<String>();
        Collection issueTypes = issueTypeManager.getIssueTypes();
        for (IssueType issueType : issueTypes) {
            String issueTypeId;
            if (issueType == null || Strings.isBlank(issueTypeId = issueType.getId())) continue;
            artifactTypeIds.add(issueTypeId);
        }
        return artifactTypeIds;
    }

    static Set<String> allIssueLinkTypeIds(IssueLinkTypeManager issueLinkTypeManager) {
        HashSet<String> issueLinkTypeIds = new HashSet<String>();
        Collection<IssueLinkType> issueLinkTypes = Jira.allIssueLinkTypes(issueLinkTypeManager);
        for (IssueLinkType issueLinkType : issueLinkTypes) {
            Long issueLinkTypeId;
            if (issueLinkType == null || (issueLinkTypeId = issueLinkType.getId()) == null) continue;
            issueLinkTypeIds.add(issueLinkTypeId.toString());
        }
        return issueLinkTypeIds;
    }

    public Map<String, Map<String, String>> artifactTypeMap() {
        Collection<IssueType> allIssueTypes = Jira.allArtifactTypes(this.issueTypeManager);
        HashMap<String, Map<String, String>> issueTypes = new HashMap<String, Map<String, String>>(allIssueTypes.size());
        for (IssueType issueType : allIssueTypes) {
            issueTypes.put(issueType.getId(), io.vavr.collection.HashMap.of("name", issueType.getName(), "description", issueType.getDescription(), "iconUrl", issueType.getCompleteIconUrl()).toJavaMap());
        }
        return issueTypes;
    }

    public Collection<String> artifactTypes(Option<Project> projectOption) {
        if (projectOption.isDefined()) {
            return this.projectConfiguration.getEnabledArtifactTypeIds(projectOption.get());
        }
        return TraceComponents.allArtifactTypeIds(this.f.issueTypeManager);
    }

    public static String defaultTraceConfigurationJavaScriptEscaped() {
        return StringEscapeUtils.escapeEcmaScript((String)TraceConfiguration.DEFAULT_TRACE_CONFIGURATION);
    }

    public Map<Long, Map<String, String>> issueLinkTypeMap() {
        Collection<IssueLinkType> allIssueLinkTypes = Jira.allIssueLinkTypes(this.f.issueLinkTypeManager);
        HashMap<Long, Map<String, String>> issueLinkTypes = new HashMap<Long, Map<String, String>>(allIssueLinkTypes.size());
        for (IssueLinkType issueLinkType : allIssueLinkTypes) {
            issueLinkTypes.put(issueLinkType.getId(), io.vavr.collection.HashMap.of("name", issueLinkType.getName(), "outward", issueLinkType.getOutward(), "inward", issueLinkType.getInward()).toJavaMap());
        }
        return issueLinkTypes;
    }

    public Collection<String> issueLinkTypes(Option<Project> projectOption) {
        if (projectOption.isDefined()) {
            return this.projectConfiguration.getEnabledIssueLinkTypeIds(projectOption.get());
        }
        return TraceComponents.allIssueLinkTypeIds(this.f.issueLinkTypeManager);
    }

    private Map<String, Map<String, String>> issuePriorityMap() {
        List priorities = this.priorityManager.getPriorities();
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(priorities.size(), 1.0f);
        for (Priority priority : priorities) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("iconUrl", priority.getIconUrl());
            entry.put("name", priority.getNameTranslation(this.f.jiraAuthenticationContext.getI18nHelper()));
            map.put(priority.getId(), entry);
        }
        return map;
    }

    public io.vavr.collection.Map<String, Object> issueRelationGraphDescription(String itemCardLayout, MessageSet messages, Collection<List<String>> relations, Map<String, Map<String, Object>> issues, IssueFieldCollector issueFieldCollector, ApplicationUser searcher) {
        Stream<Option> s = Stream.of(Option.of(Tuple.of(DATE_PICKER_JAVASCRIPT_FORMAT_KEY, DateTimeFormatUtils.getDateFormat())), Option.of(Tuple.of(DATE_TIME_PICKER_JAVASCRIPT_FORMAT_KEY, DateTimeFormatUtils.getDateTimeFormat())), Option.of(Tuple.of(ISSUES_KEY, issues)), Option.of(Tuple.of("itemCardLayout", itemCardLayout)), Option.of(Tuple.of(MESSAGES_KEY, messages.asCollection())), Option.of(Tuple.of(RELATIONS_KEY, relations)), Option.of(Tuple.of(USER_TIME_ZONE, Jira.timeZoneInfoForUser(searcher, this.f.timeZoneService).getTimeZoneId())), Option.when(issueFieldCollector.includeIssuePriorityMap(), Tuple.of(ISSUE_PRIORITY_MAP_KEY, this.issuePriorityMap())), Option.when(issueFieldCollector.includeIssueResolutionMap(), Tuple.of(ISSUE_RESOLUTION_MAP_KEY, this.issueResolutionMap())), Option.when(issueFieldCollector.includeIssueStatusMap(), Tuple.of(ISSUE_STATUS_MAP_KEY, this.issueStatusMap())), Option.when(issueFieldCollector.includeIssueTypeMap(), Tuple.of(ISSUE_TYPE_MAP_KEY, this.issueTypeMap())), Option.when(issueFieldCollector.includeProjectMap(), Tuple.of(PROJECT_MAP_KEY, issueFieldCollector.projectMap())), Option.when(issueFieldCollector.includeUserMap(), Tuple.of(USER_MAP_KEY, issueFieldCollector.userMap())));
        return s.foldLeft(io.vavr.collection.HashMap.empty(), (map, tupleOpt) -> tupleOpt.isDefined() ? map.put((Tuple2)tupleOpt.get()) : map);
    }

    public static Map<String, Object> inContextVelocityParams(String jqlQueryContextFragment, Project project, AddOnLicensing addOnLicensing, AddOnPreconditions addOnPreconditions, Factory f, UserPreferences userPreferences) {
        boolean isUserAuthenticated = f.jiraAuthenticationContext.isLoggedInUser();
        ApplicationUser user = f.jiraAuthenticationContext.getLoggedInUser();
        boolean isUserProjectAdmin = f.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
        Map<String, String> errorMessages = addOnPreconditions.getViolationsOfTypes(f.newHtmlMessageReportingAdapter(), MessageType.ERROR, new MessageType[0]).asMap();
        Stream<Option> s = Stream.concat(Stream.of(Option.of(Tuple.of(CONTEXT_PATH_KEY, f.getContextPath())), Option.of(Tuple.of(CURRENT_PROJECT_ID_KEY, project.getId())), Option.of(Tuple.of(CURRENT_PROJECT_KEY_KEY, project.getKey())), Option.of(Tuple.of("directions", "[\"inward\", \"outward\", \"parents\", \"subtasks\"]")), Option.of(Tuple.of(GRAPH_DIRECTION_KEY, "right")), Option.of(Tuple.of(IS_USER_AUTHENTICATED_KEY, isUserAuthenticated)), Option.of(Tuple.of(IS_USER_PROJECT_ADMIN_KEY, isUserProjectAdmin)), Option.of(Tuple.of(JQL_QUERY_CONTEXT_FRAGMENT_KEY, StringEscapeUtils.escapeEcmaScript((String)jqlQueryContextFragment)))), Stream.ofAll(TraceComponents.licenseBannerVelocityParams(addOnLicensing, f).entrySet()).map(entry -> Option.of(Tuple.of((String)entry.getKey(), entry.getValue()))), Stream.ofAll(userPreferences.getUserPreferences(user).entrySet()).map(entry -> Option.of(Tuple.of((String)entry.getKey(), entry.getValue()))), Stream.of(Option.when(!errorMessages.isEmpty(), Tuple.of(MESSAGES_KEY, errorMessages))));
        return s.foldLeft(io.vavr.collection.HashMap.empty(), (map, tupleOpt) -> tupleOpt.isDefined() ? map.put((Tuple2)tupleOpt.get()) : map).toJavaMap();
    }

    public static Map<String, Object> licenseBannerVelocityParams(AddOnLicensing addOnLicensing, Factory f) {
        Option<LicenseType> licenseTypeOption;
        Option<License> activeLicenseOption = addOnLicensing.getActiveLicense(f.i18nResolverAdapterOption);
        if (activeLicenseOption.isDefined() && (licenseTypeOption = activeLicenseOption.get().getLicenseType()).isDefined() && licenseTypeOption.get().displayBanner) {
            return Collections.singletonMap(LICENSE_BANNER_KEY, I18n.getText(f.i18nResolverAdapterOption, licenseTypeOption.get().i18nKey, new Serializable[0]));
        }
        return Collections.emptyMap();
    }

    private Map<String, String> issueResolutionMap() {
        List resolutions = this.resolutionManager.getResolutions();
        HashMap<String, String> map = new HashMap<String, String>(resolutions.size(), 1.0f);
        for (Resolution resolution : resolutions) {
            map.put(resolution.getId(), resolution.getNameTranslation(this.f.jiraAuthenticationContext.getI18nHelper()));
        }
        return map;
    }

    private Map<String, String> issueStatusMap() {
        Collection statuses = this.statusManager.getStatuses();
        HashMap<String, String> map = new HashMap<String, String>(statuses.size(), 1.0f);
        for (Status status : statuses) {
            map.put(status.getId(), status.getNameTranslation(this.f.jiraAuthenticationContext.getI18nHelper()));
        }
        return map;
    }

    private Map<String, Map<String, String>> issueTypeMap() {
        Collection issueTypes = this.issueTypeManager.getIssueTypes();
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(issueTypes.size(), 1.0f);
        for (IssueType issueType : issueTypes) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("iconUrl", issueType.getIconUrl());
            entry.put("name", issueType.getNameTranslation(this.f.jiraAuthenticationContext.getI18nHelper()));
            map.put(issueType.getId(), entry);
        }
        return map;
    }
}

