/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.components;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import vivid.trace.ao.MRUAO;
import vivid.trace.ao.TraceConfigurationAO;
import vivid.trace.components.Factory;
import vivid.trace.components.TraceConfigurationMRU;
import vivid.trace.datatypes.TraceConfigurations;

public class TraceConfigurationMRULinkFactory
implements WebItemProvider {
    private static final String GLOBAL_NAVIGATION_MENU_LOCATION = "vivid-trace-menu/vivid-trace-recent-traces-section";
    private static final int GLOBAL_NAVIGATION_MENU_MAX_ITEMS = 5;
    private final Factory f;
    private final TraceConfigurationMRU traceConfigurationMRU;
    private final TraceConfigurations traceConfigurations;

    public TraceConfigurationMRULinkFactory(Factory f, TraceConfigurationMRU traceConfigurationMRU, TraceConfigurations traceConfigurations) {
        this.f = f;
        this.traceConfigurationMRU = traceConfigurationMRU;
        this.traceConfigurations = traceConfigurations;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        ApplicationUser user = this.f.jiraAuthenticationContext.getLoggedInUser();
        List<MRUAO> entities = this.traceConfigurationMRU.getMRUs(user);
        ArrayList<WebItem> links = new ArrayList<WebItem>();
        Counter ctr = new Counter();
        for (MRUAO mru : entities) {
            Option<TraceConfigurationAO> traceConfiguration = this.traceConfigurations.get(Integer.parseInt(mru.getObjectId()));
            if (traceConfiguration.isEmpty()) continue;
            int itemIndex = ctr.next();
            String label = traceConfiguration.get().getName();
            links.add(TraceConfigurationMRULinkFactory.newWebItem(itemIndex, "vivid-trace-trace-configuration-link-" + itemIndex, label, label, GLOBAL_NAVIGATION_MENU_LOCATION, this.f.getContextPath() + "/secure/trace/" + "?trace=" + mru.getObjectId()));
            if (links.size() < 5) continue;
            break;
        }
        return links;
    }

    private static WebItem newWebItem(final int weight, final String id, final String label, final String title, final String section, final String url) {
        return new WebItem(){

            @Nonnull
            public String getSection() {
                return section;
            }

            @Nonnull
            public String getUrl() {
                return url;
            }

            public String getAccessKey() {
                return "";
            }

            public String getEntryPoint() {
                return "";
            }

            public String getCompleteKey() {
                return "";
            }

            public String getLabel() {
                return label;
            }

            public String getTitle() {
                return title;
            }

            public String getStyleClass() {
                return "";
            }

            public String getId() {
                return id;
            }

            @Nonnull
            public Map<String, String> getParams() {
                return Collections.emptyMap();
            }

            public int getWeight() {
                return weight;
            }
        };
    }

    private static class Counter {
        private int ctr = 0;

        private Counter() {
        }

        public int next() {
            return this.ctr++;
        }
    }
}

