/*
 * Decompiled with CFR 0.152.
 */
package vivid.trace.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import vivid.lib.messages.VTE19InternalError;
import vivid.trace.components.AddOnInformation;
import vivid.trace.components.Factory;
import vivid.trace.components.VersionComparator;

public class ApplicationVersionCondition
implements Condition {
    private static final String COMPARATOR_PARAM_KEY = "comparator";
    private static final String MAJOR_VERSION_PARAM_KEY = "majorVersion";
    private static final String MINOR_VERSION_PARAM_KEY = "minorVersion";
    private final AddOnInformation addOnInformation;
    private final Factory f;
    private VersionComparator comparator;
    private int[] versionComponents;

    public ApplicationVersionCondition(AddOnInformation addOnInformation, Factory factory) {
        this.addOnInformation = Objects.requireNonNull(addOnInformation);
        this.f = Objects.requireNonNull(factory);
    }

    public void init(Map<String, String> parameters) throws PluginParseException {
        if (!parameters.containsKey(COMPARATOR_PARAM_KEY)) {
            throw new IllegalArgumentException(VTE19InternalError.message(this.f.i18nResolverAdapterOption, "Required parameter 'comparator' was not found").getMessage());
        }
        String comparatorOperatorName = parameters.get(COMPARATOR_PARAM_KEY);
        this.comparator = VersionComparator.fromString(comparatorOperatorName, this.f.i18nResolverAdapterOption);
        ArrayList<Integer> v = new ArrayList<Integer>();
        if (!parameters.containsKey(MAJOR_VERSION_PARAM_KEY)) {
            throw new IllegalArgumentException(VTE19InternalError.message(this.f.i18nResolverAdapterOption, "Required parameter 'majorVersion' was not found").getMessage());
        }
        String major = parameters.get(MAJOR_VERSION_PARAM_KEY);
        v.add(this.decodeIntegerParameter(major, MAJOR_VERSION_PARAM_KEY));
        if (parameters.containsKey(MINOR_VERSION_PARAM_KEY)) {
            String minor = parameters.get(MINOR_VERSION_PARAM_KEY);
            v.add(this.decodeIntegerParameter(minor, MINOR_VERSION_PARAM_KEY));
        }
        this.versionComponents = ApplicationVersionCondition.convertIntegers(v);
    }

    private Integer decodeIntegerParameter(String parameterValue, String parameterName) {
        try {
            return Integer.decode(parameterValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(VTE19InternalError.message(this.f.i18nResolverAdapterOption, parameterName + " does not contain a parsable integer: \"" + parameterValue + "\"").getMessage());
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.addOnInformation.isJiraVersion(this.comparator, this.versionComponents);
    }

    private static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }
}

